/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.clock;

import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;
import dr.oldevomodel.clock.RateEvolutionLikelihood;

public class UCLikelihood
extends RateEvolutionLikelihood {
    private final Parameter variance;
    boolean isLogSpace = false;

    public UCLikelihood(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl) {
        super(bl ? "LogNormally Distributed" : "Normally Distributed", treeModel, parameter, parameter3, false);
        this.isLogSpace = bl;
        this.variance = parameter2;
        this.addVariable(parameter2);
    }

    @Override
    double branchRateChangeLogLikelihood(double d, double d2, double d3) {
        double d4 = this.variance.getParameterValue(0);
        double d5 = this.rootRateParameter.getParameterValue(0);
        if (this.isLogSpace) {
            double d6 = Math.log(d5);
            double d7 = Math.log(d2);
            return NormalDistribution.logPdf(d7, d6 - d4 / 2.0, Math.sqrt(d4)) - d7;
        }
        return NormalDistribution.logPdf(d2, d5, Math.sqrt(d4));
    }

    @Override
    double branchRateSample(double d, double d2) {
        double d3 = this.rootRateParameter.getParameterValue(0);
        double d4 = this.variance.getParameterValue(0);
        if (this.isLogSpace) {
            double d5 = Math.log(d3);
            return Math.exp(MathUtils.nextGaussian() * Math.sqrt(d4) + d5 - d4 / 2.0);
        }
        return MathUtils.nextGaussian() * Math.sqrt(d4) + d3;
    }
}

