/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.datatype.Nucleotides;

public class Codons
extends DataType {
    public static final String DESCRIPTION = "codon";
    public static final int TYPE = 2;
    public static final Codons UNIVERSAL = new Codons(GeneticCode.UNIVERSAL);
    public static final Codons VERTEBRATE_MT = new Codons(GeneticCode.VERTEBRATE_MT);
    public static final Codons YEAST = new Codons(GeneticCode.YEAST);
    public static final Codons MOLD_PROTOZOAN_MT = new Codons(GeneticCode.MOLD_PROTOZOAN_MT);
    public static final Codons MYCOPLASMA = new Codons(GeneticCode.MYCOPLASMA);
    public static final Codons INVERTEBRATE_MT = new Codons(GeneticCode.INVERTEBRATE_MT);
    public static final Codons CILIATE = new Codons(GeneticCode.CILIATE);
    public static final Codons ECHINODERM_MT = new Codons(GeneticCode.ECHINODERM_MT);
    public static final Codons EUPLOTID_NUC = new Codons(GeneticCode.EUPLOTID_NUC);
    public static final Codons BACTERIAL = new Codons(GeneticCode.BACTERIAL);
    public static final Codons ALT_YEAST = new Codons(GeneticCode.ALT_YEAST);
    public static final Codons ASCIDIAN_MT = new Codons(GeneticCode.ASCIDIAN_MT);
    public static final Codons FLATWORM_MT = new Codons(GeneticCode.FLATWORM_MT);
    public static final Codons BLEPHARISMA_NUC = new Codons(GeneticCode.BLEPHARISMA_NUC);
    public static final Codons NO_STOPS = new Codons(GeneticCode.NO_STOPS);
    public static final int UNKNOWN_STATE = 64;
    public static final int GAP_STATE = 65;
    public static final String[] CODON_TRIPLETS = new String[]{"AAA", "AAC", "AAG", "AAT", "ACA", "ACC", "ACG", "ACT", "AGA", "AGC", "AGG", "AGT", "ATA", "ATC", "ATG", "ATT", "CAA", "CAC", "CAG", "CAT", "CCA", "CCC", "CCG", "CCT", "CGA", "CGC", "CGG", "CGT", "CTA", "CTC", "CTG", "CTT", "GAA", "GAC", "GAG", "GAT", "GCA", "GCC", "GCG", "GCT", "GGA", "GGC", "GGG", "GGT", "GTA", "GTC", "GTG", "GTT", "TAA", "TAC", "TAG", "TAT", "TCA", "TCC", "TCG", "TCT", "TGA", "TGC", "TGG", "TGT", "TTA", "TTC", "TTG", "TTT", "???", "---"};
    protected GeneticCode geneticCode;
    protected int[] stateMap;
    protected int[] reverseMap;

    public Codons() {
    }

    protected Codons(GeneticCode geneticCode) {
        int n;
        this.geneticCode = geneticCode;
        this.stateCount = 64 - geneticCode.getStopCodonCount();
        this.ambiguousStateCount = 66;
        this.stateMap = new int[this.ambiguousStateCount];
        this.reverseMap = new int[this.ambiguousStateCount];
        int n2 = 0;
        int n3 = this.stateCount;
        for (n = 0; n < 64; ++n) {
            if (!geneticCode.isStopCodon(n)) {
                this.stateMap[n2] = n;
                this.reverseMap[n] = n2++;
                continue;
            }
            this.stateMap[n3] = n;
            this.reverseMap[n] = n3++;
        }
        for (n = 64; n < this.ambiguousStateCount; ++n) {
            this.stateMap[n] = n;
            this.reverseMap[n] = n;
        }
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public final int getState(char c) {
        throw new IllegalArgumentException("Codons datatype cannot be expressed as char");
    }

    @Override
    public int getUnknownState() {
        return 64;
    }

    @Override
    public int getGapState() {
        return 65;
    }

    public final int getState(char c, char c2, char c3) {
        return this.getState(Nucleotides.INSTANCE.getState(c), Nucleotides.INSTANCE.getState(c2), Nucleotides.INSTANCE.getState(c3));
    }

    public final int getCanonicalState(int n) {
        return this.stateMap[n];
    }

    public final int getState(int n, int n2, int n3) {
        if (Nucleotides.INSTANCE.isGapState(n) || Nucleotides.INSTANCE.isGapState(n2) || Nucleotides.INSTANCE.isGapState(n3)) {
            return 65;
        }
        if (Nucleotides.INSTANCE.isAmbiguousState(n) || Nucleotides.INSTANCE.isAmbiguousState(n2) || Nucleotides.INSTANCE.isAmbiguousState(n3)) {
            return 64;
        }
        int n4 = n * 16 + n2 * 4 + n3;
        return this.reverseMap[n4];
    }

    @Override
    public final char getChar(int n) {
        throw new IllegalArgumentException("Codons datatype cannot be expressed as char");
    }

    @Override
    public String getTriplet(int n) {
        return CODON_TRIPLETS[this.stateMap[n]];
    }

    public final int[] getTripletStates(int n) {
        int[] nArray = new int[]{Nucleotides.INSTANCE.getState(CODON_TRIPLETS[this.stateMap[n]].charAt(0)), Nucleotides.INSTANCE.getState(CODON_TRIPLETS[this.stateMap[n]].charAt(1)), Nucleotides.INSTANCE.getState(CODON_TRIPLETS[this.stateMap[n]].charAt(2))};
        return nArray;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 2;
    }

    public GeneticCode getGeneticCode() {
        return this.geneticCode;
    }

    public final boolean isStopCodon(int n) {
        return this.geneticCode.isStopCodon(this.stateMap[n]);
    }

    public static byte[] constructRateMap(Codons codons) {
        int n = codons.getStateCount();
        int n2 = n * (n - 1) / 2;
        return Codons.constructRateMap(n2, n, codons, codons.getGeneticCode());
    }

    public static Codons findByName(String string) {
        Codons codons = null;
        if (string.equals(GeneticCode.UNIVERSAL.getName())) {
            codons = UNIVERSAL;
        } else if (string.equals(GeneticCode.VERTEBRATE_MT.getName())) {
            codons = VERTEBRATE_MT;
        } else if (string.equals(GeneticCode.YEAST.getName())) {
            codons = YEAST;
        } else if (string.equals(GeneticCode.MOLD_PROTOZOAN_MT.getName())) {
            codons = MOLD_PROTOZOAN_MT;
        } else if (string.equals(GeneticCode.INVERTEBRATE_MT.getName())) {
            codons = INVERTEBRATE_MT;
        } else if (string.equals(GeneticCode.CILIATE.getName())) {
            codons = CILIATE;
        } else if (string.equals(GeneticCode.ECHINODERM_MT.getName())) {
            codons = ECHINODERM_MT;
        } else if (string.equals(GeneticCode.EUPLOTID_NUC.getName())) {
            codons = EUPLOTID_NUC;
        } else if (string.equals(GeneticCode.BACTERIAL.getName())) {
            codons = BACTERIAL;
        } else if (string.equals(GeneticCode.ALT_YEAST.getName())) {
            codons = ALT_YEAST;
        } else if (string.equals(GeneticCode.ASCIDIAN_MT.getName())) {
            codons = ASCIDIAN_MT;
        } else if (string.equals(GeneticCode.FLATWORM_MT.getName())) {
            codons = FLATWORM_MT;
        } else if (string.equals(GeneticCode.BLEPHARISMA_NUC.getName())) {
            codons = BLEPHARISMA_NUC;
        } else if (string.equals(GeneticCode.NO_STOPS.getName())) {
            codons = NO_STOPS;
        } else {
            throw new RuntimeException("Unknown genetics code");
        }
        return codons;
    }

    public static byte[] constructRateMap(int n, int n2, Codons codons, GeneticCode geneticCode) {
        int n3 = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n2; ++i) {
            int[] nArray = codons.getTripletStates(i);
            int n4 = nArray[0];
            int n5 = nArray[1];
            int n6 = nArray[2];
            int n7 = codons.getState(n4, n5, n6);
            int n8 = geneticCode.getAminoAcidState(codons.getCanonicalState(n7));
            for (int j = i + 1; j < n2; ++j) {
                nArray = codons.getTripletStates(j);
                int n9 = nArray[0];
                int n10 = nArray[1];
                int n11 = nArray[2];
                int n12 = codons.getState(n9, n10, n11);
                int n13 = geneticCode.getAminoAcidState(codons.getCanonicalState(n12));
                int n14 = -1;
                if (n4 != n9) {
                    n14 = n4 == 0 && n9 == 2 || n4 == 2 && n9 == 0 || n4 == 1 && n9 == 3 || n4 == 3 && n9 == 1 ? 1 : 2;
                }
                if (n5 != n10) {
                    n14 = n14 == -1 ? (n5 == 0 && n10 == 2 || n5 == 2 && n10 == 0 || n5 == 1 && n10 == 3 || n5 == 3 && n10 == 1 ? 1 : 2) : 0;
                }
                if (n6 != n11) {
                    n14 = n14 == -1 ? (n6 == 0 && n11 == 2 || n6 == 2 && n11 == 0 || n6 == 1 && n11 == 3 || n6 == 3 && n11 == 1 ? 1 : 2) : 0;
                }
                if (n14 != 0 && n8 != n13) {
                    n14 = (byte)(n14 + 2);
                }
                byArray[n3] = n14;
                ++n3;
            }
        }
        return byArray;
    }
}

