/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.NPAntigenicLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class DistanceDependentCRPGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String DDCRP_GIBBS_OPERATOR = "distanceDependentCRPGibbsOperator";
    private final Parameter chiParameter;
    private final double[][] depMatrix;
    public NPAntigenicLikelihood modelLikelihood;
    private Parameter links = null;
    private Parameter assignments = null;
    double k0;
    double v0;
    double[] m;
    double[][] T0Inv;
    double logDetT0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String CHI = "chi";
        public static final String LIKELIHOOD = "likelihood";
        public static final String ASSIGNMENTS = "assignments";
        public static final String LINKS = "links";
        public static final String DEP_MATRIX = "depMatrix";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("chi", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("likelihood", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}, true), new ElementRule("assignments", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("links", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return DistanceDependentCRPGibbsOperator.DDCRP_GIBBS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(ASSIGNMENTS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(LINKS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(CHI);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(LIKELIHOOD);
            NPAntigenicLikelihood nPAntigenicLikelihood = (NPAntigenicLikelihood)xMLObject2.getChild(NPAntigenicLikelihood.class);
            return new DistanceDependentCRPGibbsOperator(parameter2, parameter, parameter3, nPAntigenicLikelihood, d);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return DistanceDependentCRPGibbsOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public DistanceDependentCRPGibbsOperator(Parameter parameter, Parameter parameter2, Parameter parameter3, NPAntigenicLikelihood nPAntigenicLikelihood, double d) {
        this.links = parameter;
        this.assignments = parameter2;
        this.modelLikelihood = nPAntigenicLikelihood;
        this.chiParameter = parameter3;
        this.depMatrix = nPAntigenicLikelihood.getLogDepMatrix();
        for (int i = 0; i < parameter.getDimension(); ++i) {
            parameter.setParameterValue(i, i);
        }
        this.setWeight(d);
        this.m = new double[2];
        this.m[0] = this.modelLikelihood.priorMean.getParameterValue(0);
        this.m[1] = this.modelLikelihood.priorMean.getParameterValue(1);
        this.v0 = 2.0;
        this.k0 = this.modelLikelihood.priorPrec.getParameterValue(0) / this.modelLikelihood.clusterPrec.getParameterValue(0);
        this.T0Inv = new double[2][2];
        this.T0Inv[0][0] = this.v0 / this.modelLikelihood.clusterPrec.getParameterValue(0);
        this.T0Inv[1][1] = this.v0 / this.modelLikelihood.clusterPrec.getParameterValue(0);
        this.T0Inv[1][0] = 0.0;
        this.T0Inv[0][1] = 0.0;
        this.logDetT0 = -Math.log(this.T0Inv[0][0] * this.T0Inv[1][1]);
    }

    @Override
    public Parameter getParameter() {
        return this.links;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2;
        int n3 = MathUtils.nextInt(this.links.getDimension());
        int n4 = (int)this.assignments.getParameterValue(n3);
        int n5 = this.minEmpty(this.modelLikelihood.getLogLikelihoodsVector());
        this.links.setParameterValue(n3, n3);
        int[] nArray = this.connected(n3, this.links);
        int n6 = 0;
        while (nArray[n6] != 0) {
            this.assignments.setParameterValue(nArray[n6] - 1, n5);
            ++n6;
        }
        this.modelLikelihood.setLogLikelihoodsVector(n4, this.modelLikelihood.getLogLikGroup(n4));
        this.modelLikelihood.setLogLikelihoodsVector(n5, this.modelLikelihood.getLogLikGroup(n5));
        int n7 = this.maxFull(this.modelLikelihood.getLogLikelihoodsVector());
        double[] dArray = this.modelLikelihood.getLogLikelihoodsVector();
        double[] dArray2 = new double[n7 + 1];
        for (int i = 0; i < n7 + 1; ++i) {
            if (i == n5) continue;
            dArray2[i] = this.getLogLik2Group(i, n5);
        }
        double[] dArray3 = new double[this.links.getDimension()];
        for (n2 = 0; n2 < this.links.getDimension(); ++n2) {
            int n8 = n2;
            dArray3[n8] = dArray3[n8] + this.depMatrix[n3][n2];
            n = (int)this.assignments.getParameterValue(n2);
            if (n == n5) continue;
            int n9 = n2;
            dArray3[n9] = dArray3[n9] + (dArray2[n] - dArray[n] - dArray[n5]);
        }
        dArray3[n3] = Math.log(this.chiParameter.getParameterValue(0));
        this.rescale(dArray3);
        this.exp(dArray3);
        n2 = MathUtils.randomChoicePDF(dArray3);
        this.links.setParameterValue(n3, n2);
        n = (int)this.assignments.getParameterValue(n2);
        n6 = 0;
        while (nArray[n6] != 0) {
            this.assignments.setParameterValue(nArray[n6] - 1, n);
            ++n6;
        }
        this.modelLikelihood.setLogLikelihoodsVector(n, this.modelLikelihood.getLogLikGroup(n));
        if (n != n5) {
            this.modelLikelihood.setLogLikelihoodsVector(n5, 0.0);
        }
        this.sampleMeans(n7);
        return 0.0;
    }

    public int minEmpty(double[] dArray) {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            if (dArray[n] == 0.0) {
                bl = true;
                continue;
            }
            if (n == dArray.length - 1) {
                bl = true;
            }
            ++n;
        }
        return n;
    }

    public int maxFull(double[] dArray) {
        boolean bl = true;
        int n = dArray.length - 1;
        while (bl) {
            if (dArray[n] != 0.0) {
                bl = false;
                continue;
            }
            --n;
        }
        return n;
    }

    public int[] connected(int n, Parameter parameter) {
        int n2 = parameter.getDimension();
        int[] nArray = new int[n2 + 1];
        nArray[0] = n + 1;
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (nArray[i] == 0) continue;
            int n5 = nArray[i] - 1;
            int n6 = (int)parameter.getParameterValue(n5);
            nArray[n3] = n6 + 1;
            ++n3;
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                if (nArray[n4] != n6 + 1) continue;
                nArray[--n3] = 0;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if ((int)parameter.getParameterValue(n4) != n5) continue;
                nArray[n3] = n4 + 1;
                ++n3;
                for (int j = 0; j < n3 - 1; ++j) {
                    if (nArray[j] != n4 + 1) continue;
                    nArray[--n3] = 0;
                }
            }
        }
        return nArray;
    }

    private void printInformtion(Parameter parameter) {
        StringBuffer stringBuffer = new StringBuffer("parameter \n");
        for (int i = 0; i < parameter.getDimension(); ++i) {
            stringBuffer.append(parameter.getParameterValue(i));
        }
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    public double getLogLik2Group(int n, int n2) {
        throw new UnsupportedOperationException("This method has been commented out because of build errors");
    }

    public void sampleMeans(int n) {
        double[][] dArray = new double[n + 2][2];
        throw new UnsupportedOperationException("This method has been commented out because of build errors");
    }

    private void exp(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
    }

    private void rescale(double[] dArray) {
        throw new UnsupportedOperationException("This method has been commented out because of build errors");
    }

    private double max(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public final String getOperatorName() {
        return DDCRP_GIBBS_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public int getStepCount() {
        return 1;
    }
}

