/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGPartitionLikelihood;
import dr.evomodel.arg.ARGRatePrior;
import dr.evomodel.arg.operators.ARGPartitioningOperator;
import dr.evomodel.arg.operators.ObsoleteARGAddRemoveEventOperator;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class ARGAddRemoveEventOperator
extends AbstractAdaptableOperator {
    public static final String ADD_PROBABILITY = "addProbability";
    public static final String ARG_EVENT_OPERATOR = "ARGEventOperator";
    public static final String INTERNAL_NODES = "internalNodes";
    public static final String INTERNAL_AND_ROOT = "internalNodesPlusRoot";
    public static final String NODE_RATES = "nodeRates";
    public static final String BELOW_ROOT_PROBABILITY = "belowRootProbability";
    public static final String FLIP_MEAN = "flipMean";
    public static final String JOINT_PARTITIONING = "jointPartitioning";
    public static final String RELAXED = "relaxed";
    public static final double LOG_TWO = Math.log(2.0);
    private boolean relaxed = false;
    private ARGModel arg = null;
    private double size = 0.0;
    private double probBelowRoot = 0.9;
    private ARGPartitionLikelihood partLike;
    private ARGRatePrior ratePrior;
    private CompoundParameter internalNodeParameters;
    private CompoundParameter internalAndRootNodeParameters;
    private CompoundParameter nodeRates;
    private int tossSize = -1;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("addProbability", false, "The probability that the operator adds a new reassortment event"), AttributeRule.newBooleanRule("jointPartitioning", true), AttributeRule.newIntegerRule("tossSize", true), AttributeRule.newDoubleRule("addProbability", true), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newIntegerRule("weight", false), new ElementRule(ARGModel.class, false), new ElementRule(ARGPartitionLikelihood.class, false), new ElementRule(ARGRatePrior.class, true), new ElementRule("internalNodes", new XMLSyntaxRule[]{new ElementRule(CompoundParameter.class)}), new ElementRule("internalNodesPlusRoot", new XMLSyntaxRule[]{new ElementRule(CompoundParameter.class)}), new ElementRule("nodeRates", new XMLSyntaxRule[]{new ElementRule(CompoundParameter.class)})};

        @Override
        public String getParserName() {
            return ARGAddRemoveEventOperator.ARG_EVENT_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getChild(ARGAddRemoveEventOperator.INTERNAL_NODES).getChild(0);
            CompoundParameter compoundParameter2 = (CompoundParameter)xMLObject.getChild(ARGAddRemoveEventOperator.INTERNAL_AND_ROOT).getChild(0);
            CompoundParameter compoundParameter3 = (CompoundParameter)xMLObject.getChild(ARGAddRemoveEventOperator.NODE_RATES).getChild(0);
            int n = xMLObject.getIntegerAttribute("weight");
            double d = xMLObject.getDoubleAttribute(ARGAddRemoveEventOperator.ADD_PROBABILITY);
            if (!(d > 0.0) || !(d < 1.0)) {
                throw new XMLParseException("addProbability must be between 0 and 1");
            }
            d = Math.log(d / (1.0 - d));
            double d2 = 0.9;
            if (xMLObject.hasAttribute(ARGAddRemoveEventOperator.BELOW_ROOT_PROBABILITY) && ((d2 = xMLObject.getDoubleAttribute(ARGAddRemoveEventOperator.BELOW_ROOT_PROBABILITY)) >= 1.0 || d2 <= 0.0)) {
                throw new XMLParseException("belowRootProbability must fall in (0,1)");
            }
            ARGPartitionLikelihood aRGPartitionLikelihood = (ARGPartitionLikelihood)xMLObject.getChild(ARGPartitionLikelihood.class);
            int n2 = 0;
            if (xMLObject.hasAttribute("tossSize")) {
                n2 = xMLObject.getIntegerAttribute("tossSize");
                Logger.getLogger("dr.evomodel").info("ARGEventOperator is joint with argPartitionOperator");
                if (n2 <= 0 || n2 >= aRGModel.getNumberOfPartitions()) {
                    throw new XMLParseException("Toss size is incorrect");
                }
            }
            ARGRatePrior aRGRatePrior = null;
            if (xMLObject.hasAttribute(ARGAddRemoveEventOperator.RELAXED)) {
                aRGRatePrior = (ARGRatePrior)xMLObject.getChild(ARGRatePrior.class);
            }
            return new ARGAddRemoveEventOperator(aRGModel, n, d, adaptationMode, compoundParameter, compoundParameter2, compoundParameter3, d2, aRGPartitionLikelihood, aRGRatePrior, n2);
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a subarg.";
        }

        @Override
        public Class getReturnType() {
            return ObsoleteARGAddRemoveEventOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ARGAddRemoveEventOperator(ARGModel aRGModel, int n, double d, AdaptationMode adaptationMode, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3, double d2, ARGPartitionLikelihood aRGPartitionLikelihood, ARGRatePrior aRGRatePrior, int n2) {
        super(adaptationMode, 0.5);
        this.arg = aRGModel;
        this.size = d;
        this.internalNodeParameters = compoundParameter;
        this.internalAndRootNodeParameters = compoundParameter2;
        this.nodeRates = compoundParameter3;
        this.partLike = aRGPartitionLikelihood;
        this.ratePrior = aRGRatePrior;
        if (aRGRatePrior != null) {
            this.relaxed = true;
        }
        this.setWeight(n);
        this.probBelowRoot = d2;
        this.probBelowRoot = -Math.log(1.0 - Math.sqrt(this.probBelowRoot));
        this.tossSize = n2;
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        try {
            d = MathUtils.nextDouble() < 1.0 / (1.0 + Math.exp(-this.size)) ? this.AddOperation() - this.size : this.RemoveOperation() + this.size;
        }
        catch (NoReassortmentEventException noReassortmentEventException) {
            throw new RuntimeException("");
        }
        assert (!Double.isInfinite(d) && !Double.isNaN(d));
        return d;
    }

    private double AddOperation() {
        Serializable serializable;
        Object object;
        double d = 0.0;
        double d2 = this.arg.getNodeHeight(this.arg.getRoot());
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = this.probBelowRoot / d2;
        while (d3 > d2 && d4 > d2) {
            d3 = MathUtils.nextExponential(d5);
            d4 = MathUtils.nextExponential(d5);
        }
        d += d5 * (d3 + d4) - LOG_TWO - 2.0 * Math.log(d5) + Math.log(1.0 - Math.exp(-2.0 * d2 * d5));
        if (d3 < d4) {
            double d6 = d3;
            d3 = d4;
            d4 = d6;
        }
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        ArrayList<NodeRef> arrayList2 = new ArrayList<NodeRef>();
        int n = this.findPotentialAttachmentPoints(d3, arrayList);
        int n2 = this.findPotentialAttachmentPoints(d4, arrayList2);
        assert (n > 0);
        assert (n2 > 0);
        d += Math.log((double)arrayList.size() * (double)arrayList2.size());
        ARGModel.Node node = (ARGModel.Node)arrayList2.get(MathUtils.nextInt(n2));
        ARGModel.Node node2 = node.leftParent;
        ARGModel.Node node3 = node.rightParent;
        ARGModel.Node node4 = node.leftParent;
        boolean bl = true;
        if (!node.bifurcation) {
            object = new boolean[]{this.arg.getNodeHeight(node2) > d4, this.arg.getNodeHeight(node3) > d4};
            if (object[0] != false && object[1] != false) {
                if (MathUtils.nextBoolean()) {
                    bl = false;
                    node4 = node3;
                }
            } else if (object[0] == false) {
                if (object[1] != false) {
                    bl = false;
                    node4 = node3;
                } else assert (false);
            }
        }
        object = (ARGModel.Node)arrayList.get(MathUtils.nextInt(arrayList.size()));
        ARGModel.Node node5 = ((ARGModel.Node)object).leftParent;
        ARGModel.Node node6 = ((ARGModel.Node)object).rightParent;
        ARGModel.Node node7 = node5;
        boolean bl2 = true;
        if (!((ARGModel.Node)object).bifurcation) {
            boolean[] blArray = new boolean[]{this.arg.getNodeHeight(node5) > d3, this.arg.getNodeHeight(node6) > d3};
            if (blArray[0] && blArray[1]) {
                if (MathUtils.nextBoolean()) {
                    bl2 = false;
                    node7 = node6;
                }
            } else if (!blArray[0]) {
                if (blArray[1]) {
                    bl2 = false;
                    node7 = node6;
                } else assert (false);
            }
        }
        boolean bl3 = MathUtils.nextBoolean();
        d += LOG_TWO;
        ARGModel.Node node8 = this.arg.new ARGModel.Node();
        node8.bifurcation = false;
        double[] dArray = new double[]{1.0};
        if (this.relaxed) {
            dArray = this.ratePrior.generateValues();
        }
        node8.rateParameter = new Parameter.Default(dArray);
        node8.rateParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, dArray.length));
        node8.number = this.arg.getNodeCount() + 1;
        ARGModel.Node node9 = this.arg.new ARGModel.Node();
        double[] dArray2 = new double[]{1.0};
        if (this.relaxed) {
            dArray2 = this.ratePrior.generateValues();
            d += this.ratePrior.getAddHastingsRatio(dArray2);
        }
        node9.rateParameter = new Parameter.Default(dArray2);
        node9.rateParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, dArray2.length));
        node9.number = this.arg.getNodeCount();
        this.arg.beginTreeEdit();
        this.adjustRandomPartitioning();
        if (d3 < d2) {
            if (object == node) {
                if (((ARGModel.Node)object).bifurcation) {
                    ((ARGModel.Node)object).leftParent = ((ARGModel.Node)object).rightParent = node8;
                    node8.leftChild = node8.rightChild = object;
                    node8.leftParent = node8.rightParent = node9;
                    node9.leftChild = node9.rightChild = node8;
                    node9.leftParent = node9.rightParent = node7;
                    if (node7.bifurcation) {
                        if (node7.leftChild == object) {
                            node7.leftChild = node9;
                        } else {
                            node7.rightChild = node9;
                        }
                    } else {
                        node7.leftChild = node7.rightChild = node9;
                    }
                    d -= LOG_TWO;
                } else if (bl2 && bl) {
                    ((ARGModel.Node)object).leftParent = node8;
                    node8.leftChild = node8.rightChild = object;
                    node8.leftParent = node8.rightParent = node9;
                    node9.leftChild = node9.rightChild = node8;
                    node9.leftParent = node9.rightParent = node7;
                    if (node7.bifurcation) {
                        if (node7.leftChild == object) {
                            node7.leftChild = node9;
                        } else {
                            node7.rightChild = node9;
                        }
                    } else {
                        node7.leftChild = node7.rightChild = node9;
                    }
                } else if (bl2) {
                    ((ARGModel.Node)object).leftParent = node9;
                    ((ARGModel.Node)object).rightParent = node8;
                    node9.leftChild = object;
                    node9.rightChild = node8;
                    node9.leftParent = node9.rightParent = node7;
                    if (node7.bifurcation) {
                        if (node7.leftChild == object) {
                            node7.leftChild = node9;
                        } else {
                            node7.rightChild = node9;
                        }
                    } else {
                        node7.leftChild = node7.rightChild = node9;
                    }
                    node8.leftChild = node8.rightChild = object;
                    if (bl3) {
                        node8.leftParent = node9;
                        node8.rightParent = node4;
                    } else {
                        node8.rightParent = node9;
                        node8.leftParent = node4;
                    }
                    if (node4.bifurcation) {
                        if (node4.leftChild == node) {
                            node4.leftChild = node8;
                        } else {
                            node4.rightChild = node8;
                        }
                    } else {
                        node4.leftChild = node4.rightChild = node8;
                    }
                } else if (bl) {
                    ((ARGModel.Node)object).rightParent = node9;
                    ((ARGModel.Node)object).leftParent = node8;
                    node9.leftChild = object;
                    node9.rightChild = node8;
                    node9.leftParent = node9.rightParent = node7;
                    if (node7.bifurcation) {
                        if (node7.leftChild == object) {
                            node7.leftChild = node9;
                        } else {
                            node7.rightChild = node9;
                        }
                    } else {
                        node7.leftChild = node7.rightChild = node9;
                    }
                    node8.leftChild = node8.rightChild = object;
                    if (bl3) {
                        node8.leftParent = node9;
                        node8.rightParent = node4;
                    } else {
                        node8.rightParent = node9;
                        node8.leftParent = node4;
                    }
                    if (node4.bifurcation) {
                        if (node4.leftChild == node) {
                            node4.leftChild = node8;
                        } else {
                            node4.rightChild = node8;
                        }
                    } else {
                        node4.leftChild = node4.rightChild = node8;
                    }
                } else {
                    ((ARGModel.Node)object).rightParent = node8;
                    node8.leftChild = node8.rightChild = object;
                    node8.leftParent = node8.rightParent = node9;
                    node9.leftChild = node9.rightChild = node8;
                    node9.leftParent = node9.rightParent = node7;
                    if (node7.bifurcation) {
                        if (node7.leftChild == object) {
                            node7.leftChild = node9;
                        } else {
                            node7.rightChild = node9;
                        }
                    } else {
                        node7.leftChild = node7.rightChild = node9;
                    }
                    d -= LOG_TWO;
                }
            } else {
                node8.leftChild = node8.rightChild = node;
                node9.leftParent = node9.rightParent = node7;
                node9.leftChild = node8;
                node9.rightChild = object;
                if (bl3) {
                    node8.leftParent = node9;
                    node8.rightParent = node4;
                } else {
                    node8.rightParent = node9;
                    node8.leftParent = node4;
                }
                if (node.bifurcation) {
                    node.leftParent = node.rightParent = node8;
                } else if (bl) {
                    node.leftParent = node8;
                } else {
                    node.rightParent = node8;
                }
                if (node4.bifurcation) {
                    if (node4.leftChild == node) {
                        node4.leftChild = node8;
                    } else {
                        node4.rightChild = node8;
                    }
                } else {
                    node4.leftChild = node4.rightChild = node8;
                }
                if (((ARGModel.Node)object).bifurcation) {
                    ((ARGModel.Node)object).leftParent = ((ARGModel.Node)object).rightParent = node9;
                } else if (bl2) {
                    ((ARGModel.Node)object).leftParent = node9;
                } else {
                    ((ARGModel.Node)object).rightParent = node9;
                }
                if (node7.bifurcation) {
                    if (node7.leftChild == object) {
                        node7.leftChild = node9;
                    } else {
                        node7.rightChild = node9;
                    }
                } else {
                    node7.leftChild = node7.rightChild = node9;
                }
            }
            serializable = new Parameter.Default(this.arg.getNumberOfPartitions());
            this.drawRandomPartitioning((Parameter)serializable);
            node8.partitioning = serializable;
            node9.heightParameter = new Parameter.Default(d3);
            node8.heightParameter = new Parameter.Default(d4);
            node9.setupHeightBounds();
            node8.setupHeightBounds();
            this.arg.expandARG(node9, node8, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
            assert (this.nodeCheck()) : this.arg.toARGSummary();
        } else {
            assert (d4 < d2);
            node8.heightParameter = new Parameter.Default(d4);
            node8.setupHeightBounds();
            object = node9;
            if (this.arg.isRoot(node4)) {
                node4 = node9;
            }
            serializable = (ARGModel.Node)this.arg.getRoot();
            ARGModel.Node node10 = ((ARGModel.Node)serializable).leftChild;
            ARGModel.Node node11 = ((ARGModel.Node)serializable).rightChild;
            this.arg.singleRemoveChild((NodeRef)serializable, node10);
            this.arg.singleRemoveChild((NodeRef)serializable, node11);
            this.arg.singleAddChild(node9, node10);
            this.arg.singleAddChild(node9, node11);
            if (node4.isBifurcation()) {
                this.arg.singleRemoveChild(node4, node);
            } else {
                this.arg.doubleRemoveChild(node4, node);
            }
            this.arg.doubleAddChild(node8, node);
            this.arg.singleAddChild((NodeRef)serializable, node9);
            Parameter.Default default_ = new Parameter.Default(this.arg.getNumberOfPartitions());
            this.drawRandomPartitioning(default_);
            this.arg.addChildAsRecombinant((NodeRef)serializable, node4, node8, default_);
            if (bl3) {
                node8.leftParent = serializable;
                node8.rightParent = node4;
            } else {
                node8.leftParent = node4;
                node8.rightParent = serializable;
            }
            node9.heightParameter = new Parameter.Default(((ARGModel.Node)serializable).getHeight());
            node9.setupHeightBounds();
            ((ARGModel.Node)serializable).heightParameter.setParameterValue(0, d3);
            this.arg.expandARG(node9, node8, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
            assert (this.nodeCheck());
        }
        this.arg.pushTreeSizeIncreasedEvent();
        this.arg.endTreeEdit();
        try {
            this.arg.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.toString() + "\n" + this.arg.toString() + "\n" + TreeUtils.uniqueNewick(this.arg, this.arg.getRoot()));
        }
        assert (this.nodeCheck());
        d -= Math.log(this.findPotentialNodesToRemove(null));
        assert (this.nodeCheck());
        assert (!Double.isNaN(d) && !Double.isInfinite(d));
        if (node8.leftParent.bifurcation && node8.rightParent.bifurcation && node8.leftParent != node8.rightParent) {
            d -= LOG_TWO;
        }
        return d += this.getPartitionAddHastingsRatio(node8.partitioning.getParameterValues());
    }

    private int findPotentialAttachmentPoints(double d, ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            NodeRef nodeRef = this.arg.getNode(i);
            if (!this.arg.isRoot(nodeRef)) {
                if (!(this.arg.getNodeHeight(nodeRef) < d)) continue;
                ARGModel.Node node = (ARGModel.Node)this.arg.getParent(nodeRef, 0);
                ARGModel.Node node2 = (ARGModel.Node)this.arg.getParent(nodeRef, 1);
                if (this.arg.isBifurcation(nodeRef)) {
                    assert (node == node2);
                    if (!(this.arg.getNodeHeight(node) > d)) continue;
                    if (arrayList != null) {
                        arrayList.add(nodeRef);
                    }
                    ++n;
                    continue;
                }
                if (this.arg.getNodeHeight(node) > d) {
                    if (arrayList != null) {
                        arrayList.add(nodeRef);
                    }
                    ++n;
                }
                if (!(this.arg.getNodeHeight(node2) > d)) continue;
                if (arrayList != null) {
                    arrayList.add(nodeRef);
                }
                ++n;
                continue;
            }
            if (!(this.arg.getNodeHeight(nodeRef) < d)) continue;
            if (arrayList != null) {
                arrayList.add(nodeRef);
            }
            ++n;
        }
        return n;
    }

    private int findPotentialNodesToRemove(ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            ARGModel.Node node2 = node.leftParent;
            ARGModel.Node node3 = node.rightParent;
            if (!node.isReassortment() || !node2.bifurcation && !node3.bifurcation) continue;
            if (arrayList != null) {
                arrayList.add(node);
            }
            ++n;
        }
        return n;
    }

    private double RemoveOperation() throws NoReassortmentEventException {
        ARGModel.Node node;
        Object object;
        double d = 0.0;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        int n = this.findPotentialNodesToRemove(arrayList);
        if (n == 0) {
            throw new NoReassortmentEventException();
        }
        d += Math.log(n);
        ARGModel.Node node2 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(n));
        double[] dArray = node2.partitioning.getParameterValues();
        double d2 = node2.getHeight();
        double d3 = 0.0;
        double d4 = this.arg.getNodeHeight(this.arg.getRoot());
        this.arg.beginTreeEdit();
        boolean bl = false;
        Object object2 = node2.leftParent;
        ARGModel.Node node3 = node2.leftChild;
        ARGModel.Node node4 = node2.leftChild;
        ARGModel.Node node5 = node2.leftParent;
        if (node2.leftParent == node2.rightParent) {
            if (!this.arg.isRoot(node2.leftParent)) {
                d3 = ((ARGModel.Node)object2).getHeight();
                object = ((ARGModel.Node)object2).leftParent;
                this.arg.doubleRemoveChild((NodeRef)object, (NodeRef)object2);
                this.arg.doubleRemoveChild(node2, node3);
                if (((ARGModel.Node)object).bifurcation) {
                    this.arg.singleAddChild((NodeRef)object, node3);
                } else {
                    this.arg.doubleAddChild((NodeRef)object, node3);
                }
                bl = true;
                node5 = node4;
            } else {
                assert (node3.bifurcation);
                assert (false);
            }
            d += LOG_TWO;
        } else {
            ARGModel.Node node6;
            ARGModel.Node node7;
            object = null;
            ARGModel.Node node8 = null;
            if (node2.leftParent.bifurcation && node2.rightParent.bifurcation) {
                if (MathUtils.nextBoolean()) {
                    object = node2.rightParent;
                    node8 = node2.leftParent;
                } else {
                    object = node2.leftParent;
                    node8 = node2.rightParent;
                }
                d += LOG_TWO;
            } else if (node2.rightParent.bifurcation) {
                object = node2.rightParent;
                node8 = node2.leftParent;
            } else {
                object = node2.leftParent;
                node8 = node2.rightParent;
            }
            node5 = ((ARGModel.Node)object).leftChild;
            if (node5 == node2) {
                node5 = ((ARGModel.Node)object).rightChild;
            }
            d3 = ((ARGModel.Node)object).getHeight();
            if (this.arg.isRoot((NodeRef)object)) {
                node7 = (ARGModel.Node)this.arg.getOtherChild((NodeRef)object, node2);
                node6 = node7.leftChild;
                node = node7.rightChild;
                if (node7 == node8) {
                    this.arg.singleRemoveChild((NodeRef)object, node2);
                    this.arg.singleRemoveChild((NodeRef)object, node7);
                    this.arg.singleRemoveChild(node7, node6);
                    this.arg.singleRemoveChild(node7, node);
                    this.arg.singleAddChild((NodeRef)object, node6);
                    this.arg.singleAddChild((NodeRef)object, node);
                    this.arg.singleRemoveChild((NodeRef)object, node2);
                    this.arg.doubleRemoveChild(node2, node3);
                    this.arg.singleAddChild((NodeRef)object, node3);
                    ((ARGModel.Node)object).setHeight(node7.getHeight());
                    object = node7;
                } else {
                    this.arg.singleRemoveChild((NodeRef)object, node2);
                    this.arg.singleRemoveChild((NodeRef)object, node7);
                    this.arg.singleRemoveChild(node7, node6);
                    this.arg.singleRemoveChild(node7, node);
                    this.arg.singleAddChild((NodeRef)object, node6);
                    this.arg.singleAddChild((NodeRef)object, node);
                    if (node8.bifurcation) {
                        this.arg.singleRemoveChild(node8, node2);
                    } else {
                        this.arg.doubleRemoveChild(node8, node2);
                    }
                    this.arg.doubleRemoveChild(node2, node3);
                    if (node8.bifurcation) {
                        this.arg.singleAddChild(node8, node3);
                    } else {
                        this.arg.doubleAddChild(node8, node3);
                    }
                    ((ARGModel.Node)object).setHeight(node7.getHeight());
                    object = node7;
                }
            } else {
                node7 = ((ARGModel.Node)object).leftParent;
                node6 = ((ARGModel.Node)object).leftChild;
                if (node6 == node2) {
                    node6 = ((ARGModel.Node)object).rightChild;
                }
                if (node7.bifurcation) {
                    this.arg.singleRemoveChild(node7, (NodeRef)object);
                } else {
                    this.arg.doubleRemoveChild(node7, (NodeRef)object);
                }
                this.arg.singleRemoveChild((NodeRef)object, node6);
                if (node8.bifurcation) {
                    this.arg.singleRemoveChild(node8, node2);
                } else {
                    this.arg.doubleRemoveChild(node8, node2);
                }
                this.arg.doubleRemoveChild(node2, node3);
                if (node6 != node3) {
                    if (node7.bifurcation) {
                        this.arg.singleAddChild(node7, node6);
                    } else {
                        this.arg.doubleAddChild(node7, node6);
                    }
                    if (node8.bifurcation) {
                        this.arg.singleAddChild(node8, node3);
                    } else {
                        this.arg.doubleAddChild(node8, node3);
                    }
                } else {
                    if (node7.bifurcation) {
                        this.arg.singleAddChildWithOneParent(node7, node6);
                    } else {
                        this.arg.doubleAddChildWithOneParent(node7, node6);
                    }
                    if (node8.bifurcation) {
                        this.arg.singleAddChildWithOneParent(node8, node3);
                    } else {
                        this.arg.doubleAddChildWithOneParent(node8, node3);
                    }
                }
            }
            bl = true;
            object2 = object;
        }
        if (this.relaxed) {
            object = ((ARGModel.Node)object2).rateParameter.getParameterValues();
            d -= this.ratePrior.getAddHastingsRatio((double[])object);
        }
        if (bl) {
            try {
                this.arg.contractARG((ARGModel.Node)object2, node2, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.err.println(exception);
                System.exit(-1);
            }
        }
        int n2 = Math.max(((ARGModel.Node)object2).getNumber(), node2.getNumber());
        int n3 = Math.min(((ARGModel.Node)object2).getNumber(), node2.getNumber());
        int n4 = this.arg.getNodeCount();
        for (int i = 0; i < n4; ++i) {
            node = (ARGModel.Node)this.arg.getNode(i);
            if (node.getNumber() > n2) {
                --node.number;
            }
            if (node.getNumber() <= n3) continue;
            --node.number;
        }
        this.adjustRandomPartitioning();
        this.arg.pushTreeSizeDecreasedEvent();
        this.arg.endTreeEdit();
        try {
            this.arg.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.toString() + "\n" + this.arg.toString() + "\n" + TreeUtils.uniqueNewick(this.arg, this.arg.getRoot()));
        }
        assert (this.nodeCheck()) : this.arg.toARGSummary();
        double d5 = this.arg.getNodeHeight(this.arg.getRoot());
        double d6 = this.probBelowRoot / d5;
        d -= d6 * (d3 + d2) - LOG_TWO - 2.0 * Math.log(d6) + Math.log(1.0 - Math.exp(-2.0 * d5 * d6));
        d -= Math.log((double)this.findPotentialAttachmentPoints(d3, null) * (double)this.findPotentialAttachmentPoints(d2, null));
        d -= this.getPartitionAddHastingsRatio(dArray);
        d -= LOG_TWO;
        assert (this.nodeCheck());
        assert (!Double.isNaN(d) && !Double.isInfinite(d));
        return d;
    }

    private double getPartitionAddHastingsRatio(double[] dArray) {
        return -this.partLike.getLogLikelihood(dArray);
    }

    private void adjustRandomPartitioning() {
        if (this.tossSize < 1) {
            return;
        }
        if (this.arg.getReassortmentNodeCount() > 0) {
            int n = this.arg.getReassortmentNodeCount();
            Parameter parameter = this.arg.getPartitioningParameters().getParameter(MathUtils.nextInt(n));
            if (this.arg.isRecombinationPartitionType()) {
                this.adjustRecombinationPartition(parameter);
            } else {
                this.adjustReassortmentPartition(parameter);
            }
        }
    }

    private void adjustRecombinationPartition(Parameter parameter) {
        double[] dArray = parameter.getParameterValues();
        Logger.getLogger("dr.evomodel").severe("NOT IMPLENTED");
    }

    public static double arraySum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    private void adjustReassortmentPartition(Parameter parameter) {
        double[] dArray = parameter.getParameterValues();
        boolean bl = false;
        if (dArray.length == 2) {
            double d = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d;
        } else {
            while (!bl) {
                dArray = parameter.getParameterValues();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (arrayList.size() < this.tossSize) {
                    int n = MathUtils.nextInt(dArray.length - 1) + 1;
                    if (arrayList.contains(n)) continue;
                    arrayList.add(n);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (dArray[n] == 0.0) {
                        dArray[n] = 1.0;
                        continue;
                    }
                    dArray[n] = 0.0;
                }
                if (!(ARGAddRemoveEventOperator.arraySum(dArray) > 0.0)) continue;
                bl = true;
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        ARGPartitioningOperator.checkValidReassortmentPartition(parameter);
    }

    private void drawRandomPartitioning(Parameter parameter) {
        double[] dArray = this.partLike.generatePartition();
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
    }

    public boolean nodeCheck() {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.leftParent != node.rightParent && node.leftChild != node.rightChild) {
                return false;
            }
            if (node.leftParent != null && node.leftParent.leftChild.getNumber() != i && node.leftParent.rightChild.getNumber() != i) {
                return false;
            }
            if (node.rightParent != null && node.rightParent.leftChild.getNumber() != i && node.rightParent.rightChild.getNumber() != i) {
                return false;
            }
            if (node.leftChild != null && node.leftChild.leftParent.getNumber() != i && node.leftChild.rightParent.getNumber() != i) {
                return false;
            }
            if (node.rightChild == null || node.rightChild.leftParent.getNumber() == i || node.rightChild.rightParent.getNumber() == i) continue;
            return false;
        }
        return true;
    }

    public void sanityCheck() {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.bifurcation) {
                boolean bl;
                boolean bl2 = bl = node.leftChild == node.rightChild;
                if (bl && node.leftChild != null && (node.leftChild.bifurcation || node.leftChild.leftParent != node)) {
                    System.err.println("Node " + (i + 1) + " is insane.");
                    System.err.println(this.arg.toGraphString());
                    System.exit(-1);
                }
            } else if (node.leftChild != node.rightChild) {
                System.err.println("Node " + (i + 1) + " is insane.");
                System.err.println(this.arg.toGraphString());
                System.exit(-1);
            }
            if (node.isRoot()) continue;
            double d = node.getHeight();
        }
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return this.size;
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.setSize(d);
    }

    @Override
    public double getRawParameter() {
        return this.size;
    }

    @Override
    public String getAdaptableParameterName() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return ARG_EVENT_OPERATOR;
    }

    private class NoReassortmentEventException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoReassortmentEventException(String string) {
            super(string);
        }

        public NoReassortmentEventException() {
            super("");
        }
    }
}

