/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ProcessOnCoalescentIntervalDelegate {

    public static final class TransitionMatrixOperation {
        public final int outputBuffer;
        public final int decompositionBuffer;
        public final double time;

        TransitionMatrixOperation(int n, int n2, double d) {
            this.outputBuffer = n;
            this.decompositionBuffer = n2;
            this.time = d;
        }

        public String toString() {
            return this.outputBuffer + " <- " + this.decompositionBuffer + " (" + this.time + ")";
        }
    }

    public static final class BranchIntervalOperation {
        public final int outputBuffer;
        public final int inputBuffer1;
        public final int inputBuffer2;
        public final int inputMatrix1;
        public final int inputMatrix2;
        public final int accBuffer1;
        public final int accBuffer2;
        public final double intervalLength;
        public final int executionOrder;
        public final int intervalNumber;

        BranchIntervalOperation(int n, int n2, int n3, int n4, int n5, int n6, int n7, double d, int n8, int n9) {
            this.outputBuffer = n;
            this.inputBuffer1 = n2;
            this.inputBuffer2 = n3;
            this.inputMatrix1 = n4;
            this.inputMatrix2 = n5;
            this.accBuffer1 = n6;
            this.accBuffer2 = n7;
            this.intervalLength = d;
            this.executionOrder = n8;
            this.intervalNumber = n9;
        }

        public String toString() {
            return this.intervalNumber + ":" + this.outputBuffer + " <- " + this.inputBuffer1 + " (" + this.inputMatrix1 + ") + " + this.inputBuffer2 + " (" + this.inputMatrix2 + ") (" + this.intervalLength + ") [" + this.accBuffer1 + " + " + this.accBuffer2 + "] @ " + this.executionOrder;
        }
    }

    public static class BranchIntervalOperationList {
        private static final boolean CACHE_FRIENDLY = true;
        private final List<BranchIntervalOperation> operations = new ArrayList<BranchIntervalOperation>();
        private final List<Integer> starts = new ArrayList<Integer>();
        private final int[] nodeMap;
        private final int unmapped;
        private int used;

        public BranchIntervalOperationList(int n, int n2) {
            this.unmapped = n;
            this.nodeMap = new int[n2];
            Arrays.fill(this.nodeMap, -1);
            this.used = this.unmapped;
        }

        public void addOperation(BranchIntervalOperation branchIntervalOperation) {
            this.operations.add(branchIntervalOperation);
        }

        public void addStart() {
            this.starts.add(this.operations.size());
        }

        public List<BranchIntervalOperation> getOperations() {
            return this.operations;
        }

        public int map(int n) {
            if (n < this.unmapped) {
                return n;
            }
            if (this.nodeMap[n] == -1) {
                this.nodeMap[n] = this.used++;
            }
            return this.nodeMap[n];
        }

        public List<Integer> getStarts() {
            return this.starts;
        }

        public void clear() {
            this.operations.clear();
            this.starts.clear();
            Arrays.fill(this.nodeMap, -1);
            this.used = this.unmapped;
        }

        public void vectorize(int[] nArray, int[] nArray2, double[] dArray) {
            int n;
            int n2 = 0;
            for (BranchIntervalOperation branchIntervalOperation : this.operations) {
                nArray[n2] = this.map(branchIntervalOperation.outputBuffer);
                nArray[n2 + 1] = this.map(branchIntervalOperation.inputBuffer1);
                nArray[n2 + 2] = branchIntervalOperation.inputMatrix1;
                nArray[n2 + 3] = this.map(branchIntervalOperation.inputBuffer2);
                nArray[n2 + 4] = branchIntervalOperation.inputMatrix2;
                nArray[n2 + 5] = this.map(branchIntervalOperation.accBuffer1);
                nArray[n2 + 6] = this.map(branchIntervalOperation.accBuffer2);
                nArray[n2 + 7] = branchIntervalOperation.intervalNumber;
                n2 += 8;
            }
            int n3 = this.starts.size() - 1;
            for (n = 0; n < n3; ++n) {
                int n4;
                nArray2[n] = n4 = this.starts.get(n).intValue();
                dArray[n] = this.operations.get((int)n4).intervalLength;
            }
            nArray2[n] = this.starts.get(n);
        }
    }
}

