/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Matrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MatrixInverseStatistic
extends Statistic.Abstract
implements VariableListener {
    private static final String INVERSE_STATISTIC = "matrixInverse";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)};

        @Override
        public String getParserName() {
            return MatrixInverseStatistic.INVERSE_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            if (matrixParameterInterface.getColumnDimension() != matrixParameterInterface.getRowDimension()) {
                throw new XMLParseException("Only square matrices can be inverted");
            }
            return new MatrixInverseStatistic(matrixParameterInterface);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that is the matrix inverse of the child statistic.";
        }

        @Override
        public Class getReturnType() {
            return MatrixInverseStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean inverseKnown = false;
    private double[][] inverse;
    private MatrixParameterInterface matrix;

    public MatrixInverseStatistic(MatrixParameterInterface matrixParameterInterface) {
        this.matrix = matrixParameterInterface;
        matrixParameterInterface.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.matrix.getDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        if (!this.inverseKnown) {
            this.inverse = new Matrix(this.matrix.getParameterAsMatrix()).inverse().toComponents();
            this.inverseKnown = true;
        }
        int n2 = n / this.matrix.getColumnDimension();
        int n3 = n - n2 * this.matrix.getColumnDimension();
        return this.inverse[n2][n3];
    }

    @Override
    public String getDimensionName(int n) {
        return this.getStatisticName() + "." + this.matrix.getDimensionName(n);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.inverseKnown = false;
    }
}

