/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.evolution.alignment.SitePatterns;
import dr.oldevomodel.sitemodel.SiteModel;

public class ScoreMatrix {
    SiteModel siteModel;
    double time;
    double[] matrix;
    double[] logp;
    double[][] logOddScores;
    double[][] pscores;
    int stateCount;

    public ScoreMatrix(SiteModel siteModel, double d) {
        this.siteModel = siteModel;
        this.logp = siteModel.getSubstitutionModel().getFrequencyModel().getFrequencies();
        for (int i = 0; i < this.logp.length; ++i) {
            this.logp[i] = Math.log(this.logp[i]);
        }
        this.stateCount = siteModel.getFrequencyModel().getFrequencyCount();
        this.matrix = new double[this.stateCount * this.stateCount];
        this.pscores = new double[this.stateCount][this.stateCount];
        this.logOddScores = new double[this.stateCount][this.stateCount];
        this.setTime(d);
    }

    public void setTime(double d) {
        this.time = d;
        this.siteModel.getSubstitutionModel().getTransitionProbabilities(d, this.matrix);
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                this.pscores[i][j] = Math.log(this.matrix[i * this.stateCount + j]);
                this.logOddScores[i][j] = this.pscores[i][j] - this.logp[i] - this.logp[j];
            }
        }
    }

    public final double getScore(int n, int n2) {
        return this.pscores[n][n2] - this.logp[n2];
    }

    public final double getScore(SitePatterns sitePatterns) {
        if (sitePatterns.getPatternLength() != 2) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < sitePatterns.getPatternCount(); ++i) {
            double d2 = sitePatterns.getPatternWeight(i);
            int[] nArray = sitePatterns.getPattern(i);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n >= this.stateCount || n2 >= this.stateCount) continue;
            d += this.getScore(n, n2) * d2;
        }
        return d;
    }
}

