% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{compareDBNs}
\alias{compareDBNs}
\title{Comparing two DBNs}
\usage{
compareDBNs(eDBN, trueDBN, struct = c("init", "trans"), b = 0)
}
\arguments{
\item{eDBN}{an object of class \code{\link[graph]{graphNEL}} (or an ajacency matrix corresponding to this DBN), representing the DBN which should be compared to a ground truth DBN}

\item{trueDBN}{an object of class \code{\link[graph]{graphNEL}} (or an ajacency matrix corresponding to this DBN), representing the ground truth DBN}

\item{struct}{option used to determine if the initial or the transitional structure should be compared; accaptable values are init or trans}

\item{b}{number of static variables in one time slice of a DBN; note that for function to work correctly all static variables have to be in the first b columns of the matrix}
}
\value{
a vector of 5: SHD, number of true positive edges, number of false positive edges, number of false negative edges and true positive rate
}
\description{
This function compares one (estimated) DBN structure to another DBN (true DBN). Comparisons for initial and transitional structures are returned separately if \code{equalstruct} equals \code{TRUE}.
}
\examples{
testscore<-scoreparameters("bge", DBNdata, DBN=TRUE, 
dbnpar=list(samestruct=TRUE, slices=5, b=3))
\dontrun{
DBNfit<-iterativeMCMC(testscore, moveprobs=c(0.11,0.84,0.04,0.01))
compareDBNs(DBNfit$DAG,DBNmat, struct="trans", b=3)
}
}
