% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdImpute_snps_hdf5}
\alias{bdImpute_snps_hdf5}
\title{Impute SNPs in hdf5 omic dataset}
\usage{
bdImpute_snps_hdf5(
  filename,
  group,
  dataset,
  outgroup = NULL,
  outdataset = NULL,
  bycols = TRUE
)
}
\arguments{
\item{filename, }{character array indicating the name of the file to create}

\item{group, }{character array indicating the input group where the data set to be imputed is.}

\item{dataset, }{character array indicating the input dataset to be imputed}

\item{outgroup, }{optional character array indicating group where the data set will be saved after imputation if `outgroup` is NULL, output dataset is stored in the same input group.}

\item{outdataset, }{optional character array indicating dataset to store the resulting data after imputation if `outdataset` is NULL, input dataset will be overwritten.}

\item{bycols, }{boolean by default = true, true indicates that the imputation will be done by columns, otherwise, the imputation will be done by rows}
}
\value{
Original hdf5 data file with imputed data
}
\description{
Impute SNPs in hdf5 omic dataset
}
