% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install.github}
\alias{install.github}
\title{Install from Github}
\usage{
install.github(name = "", destdir = "./", version = NULL,
  show.all.versions = FALSE, name.saved = NULL,
  github.cfg = system.file("extdata", "github.toml", package =
  "BioInstaller"), db = Sys.getenv("BIO_SOFTWARES_DB_ACTIVE",
  system.file("extdata", "softwares_db_demo.yaml", package = "BioInstaller")),
  download.only = FALSE, showWarnings = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{name}{Software name}

\item{destdir}{A string, point the install path}

\item{version}{Software version}

\item{show.all.versions}{Logical wheather show all avaliable version can be install}

\item{name.saved}{Software name when you want to install different version, you
can use this to point the installed softwares name like 'GATK-3.7'}

\item{github.cfg}{Configuration file of installed by github url,
default is system.file('extdata', 'github.toml', package='BioInstaller')}

\item{db}{File of saving softwares infomation, default is Sys.getenv('BIO_SOFTWARES_DB_ACTIVE',
system.file('extdata', 'softwares_db_demo.yaml', package = 'BioInstaller'))}

\item{download.only}{Logicol indicating wheather only download source or file (non-github)}

\item{showWarnings}{Logical should the warnings on failure be shown?}

\item{verbose}{TRUE is debug mode}

\item{...}{Other key and value paired need be saved in BioInstaller passed to \code{\link{change.info}}}
}
\value{
Bool Value
}
\description{
Install from Github
}
\examples{
set.biosoftwares.db(sprintf('\%s/.BioInstaller', tempdir()))
install.github('bwa', destdir = sprintf('\%s/bwa_example', tempdir()), verbose = TRUE)
}
