% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/101-getDrug.R
\name{getDrug}
\alias{getDrug}
\alias{BMgetDrug}
\alias{BMgetDrugMolPubChem}
\alias{BMgetDrugSmiPubChem}
\alias{BMgetDrugMolChEMBL}
\alias{BMgetDrugSmiChEMBL}
\alias{BMDrugMolCAS}
\alias{BMgetDrugMolKEGG}
\alias{BMgetDrugSmiKEGG}
\alias{BMgetDrugMolDrugBank}
\alias{BMgetDrugSmiDrugBank}
\title{Retrieve Drug Molecules in MOL and SMILES Format from Databases}
\usage{
BMgetDrug(id, from = c("pubchem", "chembl", "cas", "kegg", "drugbank"),
  type = c("mol", "smile"), parallel = 5)

BMgetDrugMolPubChem(id, parallel = 5)

BMgetDrugSmiPubChem(id, parallel = 5)

BMgetDrugMolChEMBL(id, parallel = 5)

BMgetDrugSmiChEMBL(id, parallel = 5)

BMDrugMolCAS(id, parallel = 5)

BMgetDrugMolKEGG(id, parallel = 5)

BMgetDrugSmiKEGG(id, parallel = 5)

BMgetDrugMolDrugBank(id, parallel = 5)

BMgetDrugSmiDrugBank(id, parallel = 5)
}
\arguments{
\item{id}{A character vector, as the drug ID(s).}

\item{from}{The database, one of \code{'pubchem'}, \code{'chembl'}, \code{'cas'}, 
\code{'kegg'}, \code{'drugbank'}.}

\item{type}{The returned molecule format, \code{mol} or \code{smile}.}

\item{parallel}{An integer, the parallel parameter, indicates how many 
process the user would like to use for retrieving 
the data (using RCurl), default is \code{5}. 
For regular cases, we recommend a number less than \code{20}.}
}
\value{
A length of \code{id} character vector, 
each element containing the corresponding drug molecule.
}
\description{
Retrieve Drug Molecules in MOL and SMILES Format from Databases(BMgetDrug)

Retrieve Drug Molecules in MOL and Smi Format from the PubChem 
Database(BMgetDrug...PubChem)

Retrieve Drug Molecules in MOL and Smi Format from the ChEMBL 
Database(BMgetDrug...ChEMBL)

Retrieve Drug Molecules in InChI Format from the CAS Database(BMDrugMolCAS)

Retrieve Drug Molecules in MOL and Smi Format from the KEGG 
Database(BMgetDrug...KEGG)

Retrieve Drug Molecules in MOL and Smi Format from the DrugBank 
Database(BMgetDrug...DrugBank)
}
\details{
This function retrieves drug molecules in MOL and SMILES format from five databases.

This function retrieves drug molecules in MOL format from the PubChem database.

This function retrieves drug molecules in MOL format from the ChEMBL database.

This function retrieves drug molecules in InChI format from the CAS database.
CAS database only provides InChI data, so here we return the molecule 
in InChI format, users could convert them to SMILES format using 
Open Babel (\url{http://openbabel.org/}) or other third-party tools.

This function retrieves drug molecules in MOL format from the KEGG database.

This function retrieves drug molecules in MOL format from the DrugBank database.
}
\examples{
\donttest{
# BMgetDrug
id = c('DB00859', 'DB00860')
BMgetDrug(id, 'drugbank', 'smile')}

\donttest{
# BMgetDrugMolPubChem
id = c('7847562', '7847563')  # Penicillamine
BMgetDrugMolPubChem(id)}

\donttest{
# BMgetDrugsmiPubChem
id = c('7847562', '7847563')  # Penicillamine
BMgetDrugSmiPubChem(id)}

\donttest{
# BMgetDrugMolChEMBL
id = 'CHEMBL1430'  # Penicillamine
BMgetDrugMolChEMBL(id)}

\donttest{
# BMgetDrugSmiChEMBL
id = 'CHEMBL1430'  # Penicillamine
BMgetDrugSmiChEMBL(id)}

\donttest{
# BMDrugMolCAS
id = '52-67-5'  # Penicillamine
BMDrugMolCAS(id)}

\donttest{
# BMgetDrugMolKEGG
id = 'D00496'  # Penicillamine
BMgetDrugMolKEGG(id)}

\donttest{
# BMgetDrugSmiKEGG
id = 'D00496'  # Penicillamine
BMgetDrugSmiKEGG(id)}

\donttest{
# BMgetDrugMolDrugBank
id = 'DB00859'  # Penicillamine
BMgetDrugMolDrugBank(id)}

\donttest{
# BMgetDrugSmiDrugBank
id = 'DB00859'  # Penicillamine
BMgetDrugSmiDrugBank(id)}

}
\seealso{
See \code{\link{BMgetProt}} for retrieving protein sequences 
from three databases.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{BMDrugMolCAS}
\keyword{BMgetDrug}
\keyword{BMgetDrugMolChEMBL}
\keyword{BMgetDrugMolDrugBank}
\keyword{BMgetDrugMolKEGG}
\keyword{BMgetDrugMolPubChem}
\keyword{BMgetDrugSmiChEMBL}
\keyword{BMgetDrugSmiDrugBank}
\keyword{BMgetDrugSmiKEGG}
\keyword{BMgetDrugSmiPubChem}
\keyword{CAS}
\keyword{ChEMBL}
\keyword{DrugBank}
\keyword{KEGG}
\keyword{PubChem}
\keyword{getDrug}
