% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment_summaries.R
\name{plot_enrichment_summaries}
\alias{plot_enrichment_summaries}
\title{Plotting Prognostic Enrichment Estimates}
\usage{
plot_enrichment_summaries(x, text.size.x.axis = 10, text.size.y.axis = 10,
  text.size.plot.title = 10, text.size.axis.ticks = 10,
  annotate.no.screening.cost = FALSE, smooth.roc = TRUE)
}
\arguments{
\item{x}{the object returned by either the \code{\link{enrichment_analysis}} or the \code{\link{enrichment_simulation}} function.}

\item{text.size.x.axis}{Size of text for the x-axis of plots. Defaults to 10.}

\item{text.size.y.axis}{Size of text for the y-axis of plots. Defaults to 10.}

\item{text.size.plot.title}{Size of text for the plot titles. Defaults to 10.}

\item{text.size.axis.ticks}{Size of axis tick marks for plots. Defaults to 10.}

\item{annotate.no.screening.cost}{Logical indicating whether to annotate the relative to total cost curve at the point where no biomarker screening occurs. Defaults to FALSE}

\item{smooth.roc}{Logical indiciating whether the ROC curves (plotting with the roc() function in the `pROC' package) should be smoothed. Defaults to TRUE.}
}
\value{
A grid of either 4 or 6 plots, summarizing the results of either the \code{\link{enrichment_analysis}} or the \code{\link{enrichment_simulation}} function.
}
\description{
Plot summaries of prognostic enrichment of clinical trials estimated by the \code{\link{enrichment_analysis}} and \code{\link{enrichment_simulation}} functions.
}
\examples{

data(dcaData)
analysis.single.marker <- enrichment_analysis(Cancer ~ Marker1,
data=dcaData,
cost.screening=100, cost.keeping=1000)
plot_enrichment_summaries(analysis.single.marker)
analysis.two.markers <- enrichment_analysis(Cancer ~ Marker1 + Marker2,
data=dcaData,
cost.screening=100,
cost.keeping=1000)
plot_enrichment_summaries(analysis.two.markers)
}
\seealso{
\code{\link{enrichment_analysis}}, \code{\link{enrichment_simulation}}
}

