% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCormat.R
\name{getCormat}
\alias{getCormat}
\title{Identification of co-expressing genes}
\usage{
getCormat(peakdet, exprmat, method = "spearman")
}
\arguments{
\item{peakdet}{A list returned by the peakDetection function.}

\item{exprmat}{A numeric matrix with expression series data with variables as rownames.}

\item{method}{A character string defining the correlation algorithm. Options are: c('pearson', 'kendall', 'spearman').}
}
\value{
Returns both the heatmap object and the re-ordered correlation matrix:
}
\description{
The getCormat function calculates a pair-wise correlation matrix and plots a bi-clustered heatmap.
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Define series
series <- c(37,40,41,42,43)
# Run the peak detection algorithm
peakdet <- peakDetection(heat, series, type ='rnaseq', actstrength = 1.5,
prominence = 1.3, minexpr = 5000)
# calculate and plot correlation matrix
corobjects <- getCormat(peakdet, heat, method = 'spearman')

}
\author{
David Lauenstein
}
