% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AccrInt.R
\name{AccrInt}
\alias{AccrInt}
\title{AccrInt (calculation of accrued interest)}
\usage{
AccrInt(StartDate = as.Date(NA), EndDate = as.Date(NA),
  Coup = as.numeric(NA), DCC = as.numeric(NA), RV = as.numeric(NA),
  CpY = as.numeric(NA), Mat = as.Date(NA), YearNCP = as.Date(NA),
  EOM = as.numeric(NA), DateOrigin = as.Date("1970-01-01"),
  InputCheck = 1)
}
\arguments{
\item{StartDate}{Calendar date on which interest accrual starts. Date class object with format "\%Y-\%m-\%d". (required)}

\item{EndDate}{Calendar date up to which interest accrues. Date class object with format "\%Y-\%m-\%d". (required)}

\item{Coup}{Nominal interest rate per year in percent. (required)}

\item{DCC}{The day count convention for interest accrual. (required)}

\item{RV}{The redemption value of the bond. Default: 100.}

\item{CpY}{Number of interest payments per year (non-negative integer; element of the set
\{1,2,3,4,6,12\}. Default: 2.}

\item{Mat}{So-called "maturity date" i.e. date on which the redemption value and the final interest
are paid. Date class object with format "\%Y-\%m-\%d".}

\item{YearNCP}{Year figure of the next coupon payment date after \code{EndDate}.}

\item{EOM}{Boolean indicating whether the bond follows the End-of-Month rule.}

\item{DateOrigin}{Determines the starting point for the daycount in "Date" objects.
Default: "1970-01-01".}

\item{InputCheck}{If 1, the input variables are checked for the correct format. Default: 1.}
}
\value{
\describe{
    \item{AccrInt}{
      Accrued interest on \code{EndDate}, given the other characteristics.
    }
    \item{DaysAccrued}{
      The number of days of interest from \code{StartDate} to \code{EndDate}.
    }
  }
}
\description{
\bold{AccrInt} returns the amount of interest accrued from some starting date
up to some end date and the number of days of interest on the end date.
}
\details{
\tabular{cl}{
      \code{DCC} \tab required input \cr
          _____________________ \tab _____________________________________________ \cr
      1,3,5,6,8,10,11,12,15,16 \tab \code{StartDate}, \code{EndDate},
                                    \code{Coup}, \code{DCC}, \code{RV} \cr
                          2,14 \tab \code{StartDate}, \code{EndDate},
                                    \code{Coup}, \code{DCC}, \code{RV},
                                    \code{CpY}, \code{EOM} \cr
                             4 \tab \code{StartDate}, \code{EndDate},
                                    \code{Coup}, \code{DCC}, \code{RV},
                                    \code{CpY}, \code{EOM},
                                    \code{YearNCP} \cr
                             7 \tab \code{StartDate}, \code{EndDate},
                                    \code{Coup}, \code{DCC}, \code{RV},
                                    \code{Mat} \cr
                          9,13 \tab \code{StartDate}, \code{EndDate},
                                    \code{Coup}, \code{DCC}, \code{RV},
                                    \code{EOM} \cr
           =================== \tab ======================================== \cr
    }

Assuming that there is no accrued interest on \code{StartDate} the function
\bold{AccrInt} computes the amount of interest accrued up to \code{EndDate}
under the terms of the specified day count convention \code{DCC}. The function
returns a list of two numerics \code{AccrInt}, and \code{DaysAccrued}.
If \code{InputCheck = 1} the input variables are checked for the correct
format. The core feature of this function is the proper handling of the
\emph{\bold{day count conventions}} presented below. The type of the day
count convention determines the amount of the accrued interest that has
to be paid by the buyer in the secondary market if the settlement
takes place between two coupon payment dates.

\itemize{
  \item Many different day count conventions are used in the market.
        Since there is no central authority that develops these conventions
        there is no standardized nomenclature. The tables below provide
        alternative names that often are used for the respective conventions.
        Type \code{View(List.DCC)} for a list of the day count methods
        currently implemented.
  \item Detailed descriptions of the conventions and their application may
        be found in Djatschenko (2018), and the other provided references.
}

\bold{Day Count Conventions}

\describe{
  \item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/Actual (ISDA)}                      \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 1                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Actual/Actual, Act/Act, Act/Act (ISDA)           \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (1998); ISDA (2006) section 4.16 (b)        \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/Actual (ICMA)}                      \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 2                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Actual/Actual (ISMA), Act/Act (ISMA),            \cr
                   \tab | \tab     \tab Act/Act (ICMA), ISMA-99                          \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ICMA Rule 251; ISDA (2006) section 4.16 (c);     \cr
                   \tab | \tab     \tab SWX (2003)                                       \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/Actual (AFB)}                       \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 3                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab AFB Method, Actual/Actual (Euro),                \cr
                   \tab | \tab     \tab Actual/Actual AFB FBF, ACT/365-366 (leap day)    \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (1998); EBF (2004)                          \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/365L}                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 4                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Act/365-366, ISMA-Year                           \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ICMA Rule 251; SWX (2003)                        \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30/360}                                    \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 5                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab 360/360, Bond Basis, 30/360 ISDA                 \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (2006) section 4.16 (f);                    \cr
                   \tab | \tab     \tab MSRB (2017) Rule G-33                            \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30E/360}                                   \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 6                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Eurobond Basis, Special German (30S/360),        \cr
                   \tab | \tab     \tab ISMA-30/360                                      \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ICMA Rule 251; ISDA (2006) section 4.16 (g);     \cr
                   \tab | \tab     \tab SWX (2003)                                       \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30E/360 (ISDA)}                            \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 7                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab none                                             \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (2006) section 4.16 (h)                     \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30/360 (German)}                           \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 8                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab 360/360 (German Master); German (30/360)         \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab EBF (2004); SWX (2003)                           \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30/360 US}                                 \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 9                                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab 30/360, US (30U/360), 30/360 (SIA)               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab Mayle (1993); SWX (2003)                         \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/365 (Fixed)}                        \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 10                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Act/365 (Fixed), A/365 (Fixed), A/365F, English  \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (2006) section 4.16 (d); SWX (2003)         \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual(NL)/365}                            \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 11                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Act(No Leap Year)/365                            \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab Krgin (2002); Thomson Reuters EIKON              \cr
         ==========\tab | \tab === \tab ===========================================      \cr
                   \tab   \tab     \tab                                                  \cr
                   \tab   \tab     \tab                                                  \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Actual/360}                                \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 12                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab Act/360, A/360, French                           \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab ISDA (2006) section 4.16 (e); SWX (2003)         \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{30/365}                                    \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 13                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab Krgin (2002); Thomson Reuters EIKON              \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Act/365 (Canadian Bond)}                   \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 14                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab IIAC (2018); Thomson Reuters EIKON               \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{Act/364}                                   \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 15                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab Thomson Reuters EIKON                            \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

\item{}{
    \tabular{cccl}{
                   \tab   \tab     \tab \bold{BusDay/252 (Brazilian)}                    \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
               DCC \tab | \tab  =  \tab 16                                               \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
       other names \tab | \tab     \tab BUS/252, BD/252                                  \cr
        ___________\tab | \tab ___ \tab ________________________________________________ \cr
        references \tab | \tab     \tab Caputo Silva et al. (2010),                      \cr
                   \tab | \tab     \tab Itau Unibanco S.A. (2017)                        \cr
         ==========\tab | \tab === \tab ===========================================      \cr
    }
  }

}
}
\examples{
StartDate<-rep(as.Date("2011-08-31"),16)
EndDate<-rep(as.Date("2012-02-29"),16)
Coup<-rep(5.25,16)
DCC<-seq(1,16)
RV<-rep(10000,16)
CpY<-rep(2,16)
Mat<-rep(as.Date("2021-08-31"),16)
YearNCP<-rep(2012,16)
EOM<-rep(1,16)

DCC_Comparison<-data.frame(StartDate,EndDate,Coup,DCC,RV,CpY,Mat,YearNCP,EOM)

AccrIntOutput<-apply(DCC_Comparison[,c('StartDate','EndDate','Coup','DCC',
'RV','CpY','Mat','YearNCP','EOM')],1,function(y) AccrInt(y[1],y[2],y[3],
y[4],y[5],y[6],y[7],y[8],y[9]))
# warnings are due to apply's conversion of the variables' classes in
# DCC_Comparison to class "character"
Accrued_Interest<-do.call(rbind,lapply(AccrIntOutput, function(x) x[[1]]))
Days_Accrued<-do.call(rbind,lapply(AccrIntOutput, function(x) x[[2]]))
DCC_Comparison<-cbind(DCC_Comparison,Accrued_Interest,Days_Accrued)
DCC_Comparison


}
\references{
\enumerate{
  \item{Banking Federation of the European Union (EBF), 2004, Master Agreement for Financial Transactions - Supplement to the Derivatives Annex - Interest Rate Transactions.}
  \item{Caputo Silva, Anderson, Lena Oliveira de Carvalho, and Octavio Ladeira de Medeiros, 2010, \emph{Public Debt: The Brazilian Experience} (National Treasury Secretariat and World Bank, Brasilia, BR).}
  \item{Djatschenko, Wadim, The Nitty Gritty of Bond Valuation: A Generalized Methodology for Fixed Coupon Bond Analysis Allowing for Irregular Periods and Various Day Count Conventions (November 5, 2018). Available at SSRN: https://ssrn.com/abstract=3205167.}
  \item{International Capital Market Association (ICMA), 2010, Rule 251 Accrued Interest Calculation - Excerpt from ICMA's Rules and Recommendations.}
  \item{Investment Industry Association of Canada (IIAC), 2018, Canadian Conventions in Fixed Income Markets - A Reference Document of Fixed Income Securities Formulas and Practices; Release: 1.3.}
  \item{International Swaps and Derivatives Association (ISDA), Inc., 1998, "EMU and Market Conventions: Recent Developments".}
  \item{International Swaps and Derivatives Association (ISDA), 2006, Inc., \emph{2006 ISDA Definitions.}, New York.}
  \item{Itau Unibanco S.A., 2017, Brazilian Sovereign Fixed Income and Foreign Exchange Markets - Handbook (First Edition).}
  \item{Krgin, Dragomir, 2002, The Handbook of Global Fixed Income Calculations. (Wiley, New York).}
  \item{Mayle, Jan, 1993, Standard Securities Calculation Methods: Fixed Income Securities Formulas for Price, Yield, and Accrued Interest, volume 1, New York: Securities Industry Association, third edition.}
  \item{Municipal Securities Rulemaking Board (MSRB), 2017, MSRB Rule Book, Washington, DC: Municipal Securities Rulemaking Board.}
  \item{SWX Swiss Exchange and D. Christie, 2003, "Accrued Interest & Yield Calculations and Determination of Holiday Calendars".}
}
}
