% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DP.R
\name{DP}
\alias{DP}
\title{DP (dirty price calculation of a fixed-coupon bond)}
\usage{
DP(CP = as.numeric(NA), SETT = as.Date(NA), Em = as.Date(NA),
  Mat = as.Date(NA), CpY = as.numeric(NA), FIPD = as.Date(NA),
  LIPD = as.Date(NA), FIAD = as.Date(NA), RV = as.numeric(NA),
  Coup = as.numeric(NA), DCC = as.numeric(NA), EOM = as.numeric(NA),
  DateOrigin = as.Date("1970-01-01"), InputCheck = 1,
  FindEOM = FALSE, RegCF.equal = 0, AnnivDatesOutput = as.list(NA))
}
\arguments{
\item{CP}{The bond's clean price.}

\item{SETT}{The settlement date. Date class object with format "\%Y-\%m-\%d". (required)}

\item{Em}{The bond's issue date. Date class object with format "\%Y-\%m-\%d". (required)}

\item{Mat}{So-called "maturity date" i.e. date on which the redemption value and the final interest
are paid. Date class object with format "\%Y-\%m-\%d". (required)}

\item{CpY}{Number of interest payments per year (non-negative integer; element of the set
\{0,1,2,3,4,6,12\}. Default: 2.}

\item{FIPD}{First interest payment date after \code{Em}. Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{LIPD}{Last interest payment date before \code{Mat}. Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{FIAD}{Date on which the interest accrual starts (so-called "dated date"). Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{RV}{The redemption value of the bond. Default: 100.}

\item{Coup}{Nominal interest rate per year in percent. Default: \code{NA}.}

\item{DCC}{The day count convention the bond follows. Default: \code{NA}.
For a list of day count conventions currently implemented type \code{View(List.DCC)}.}

\item{EOM}{Boolean indicating whether the bond follows the End-of-Month rule. Default: \code{NA}.}

\item{DateOrigin}{Determines the starting point for the daycount in "Date" objects.
Default: "1970-01-01".}

\item{InputCheck}{If 1, the input variables are checked for the correct format. Default: 1.}

\item{FindEOM}{If \code{TRUE}, \code{EOM} is overridden by the value inferred from the data.
Default: \code{FALSE}.}

\item{RegCF.equal}{If 0, the amounts of regular cash flows are calculated according to the
stipulated \code{DCC}. Any other value forces all regular cash flows to be equal sized.
Default: 0.}

\item{AnnivDatesOutput}{A list containing the output of the function AnnivDates. Default: \code{NA}.}
}
\value{
\describe{
    \item{\emph{\bold{Dates}} (data frame)}{
      \describe{
        \item{\emph{Previous_CouponDate}}{}
        \item{\emph{SettlementDate}}{}
        \item{\emph{Next_CouponDate}}{}
        \item{\emph{DaysAccrued}}{The number of days accrued from \emph{Previous_CouponDate} to
                                  \emph{Next_CouponDate}, incl. the earlier and excl. the later
                                  date.}
        \item{\emph{DaysInPeriod}}{The number of interest accruing days in the coupon period
                                   from \emph{Previous_CouponDate} to \emph{Next_CouponDate}.}
      }
    }
    \item{\emph{\bold{Cash}} (data frame)}{
      \describe{
        \item{\emph{Dirty_Price}}{Sum of \emph{Clean_Price} and \emph{Accrued_Interest}.}
        \item{\emph{Clean_Price}}{The clean price entered.}
        \item{\emph{Accrued_Interest}}{The amount of accrued interest on \emph{SettlementDate}.}
        \item{\emph{CouponPayment}}{The interest payment on \emph{Next_CouponDate}.}
      }
    }
  }
}
\description{
\bold{DP} returns a bond's temporal and pecuniary characteristics on the desired calendar date
according to the methodology presented in Djatschenko (2018).
}
\details{
The function \bold{DP} generates a list of the two data frames \code{Dates} and \code{Cash},
which contain the relevant date-related and pecuniary characteristics that were either provided
by the user or calculated by the function. \bold{Value} provides further information on the
output.
}
\examples{
CP<-rep(100,16)
SETT<-rep(as.Date("2014-10-15"),16)
Em<-rep(as.Date("2013-11-30"),16)
Mat<-rep(as.Date("2021-04-21"),16)
CpY<-rep(2,16)
FIPD<-rep(as.Date("2015-02-28"),16)
LIPD<-rep(as.Date("2020-02-29"),16)
FIAD<-rep(as.Date("2013-11-30"),16)
RV<-rep(100,16)
Coup<-rep(5.25,16)
DCC<-seq(1,16,by=1)
DP.DCC_Comparison<-data.frame(CP,SETT,Em,Mat,CpY,FIPD,LIPD,FIAD,RV,Coup,DCC)

# you can pass an array to AnnivDates
List<-suppressWarnings(
        AnnivDates(unlist(DP.DCC_Comparison[1,c(3:11)],use.names=FALSE))
)

# and use its output in DP
suppressWarnings(
       DP(unlist(DP.DCC_Comparison[1,c(1:11)],use.names=FALSE),AnnivDatesOutput=List)
)

# or just apply DP to the data frame
DP.Output<-suppressWarnings(
              apply(DP.DCC_Comparison[,c('CP','SETT','Em','Mat','CpY','FIPD',
                                           'LIPD','FIAD','RV','Coup','DCC')],
                     1,function(y) DP(y[1],y[2],y[3],y[4],y[5],y[6],y[7],
                                      y[8],y[9],y[10],y[11])))

DiryPrice<-do.call(rbind,lapply(lapply(DP.Output, `[[`, 2), `[[`, 1))
DP.DCC_Comparison<-cbind(DP.DCC_Comparison,DiryPrice)
DP.DCC_Comparison

}
\references{
\enumerate{
  \item{Djatschenko, Wadim, The Nitty Gritty of Bond Valuation: A Generalized Methodology for Fixed Coupon Bond Analysis Allowing for Irregular Periods and Various Day Count Conventions (November 5, 2018). Available at SSRN: https://ssrn.com/abstract=3205167.}
}
}
