% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{cross}
\alias{cross}
\title{Cross with random mating, or equal contributions, or randomly between two populations}
\usage{
cross(sEnv = NULL, nProgeny = 100, equalContribution = F,
  popID = NULL, popID2 = NULL, notWithinFam = F, pedigree = NULL)
}
\arguments{
\item{sEnv}{the environment that BSL functions operate in. If NULL, the default \code{simEnv} is attempted}

\item{nProgeny}{the number of progenies. Default: 100}

\item{equalContribution}{if T all individuals used the same number of times as parents, if F individuals chosen at random to be parents. Default: F}

\item{popID}{population ID to be crossed. Default: the last population}

\item{popID2}{population ID to be crossed with popID to make hybrids. Default: second population not used}

\item{notWithinFam}{if TRUE, like equalContribution, all individuals are used the same number of times as parents and self-fertilization is not allowed. In addition, half- and full-sibs are not allowed to mate. Default: F}

\item{pedigree}{optional two- or three-column matrix: the first two columns are the GIDs that you want to cross, the third column is the number of progeny from that cross. NOTE: pedigree supersedes the nProgeny, equalContribution, popID, popID2, and notWithinFam parameters. You have to know what you are doing to use this parameter. Default: NULL}
}
\value{
modifies the list sims in environment sEnv by creating a progeny population as specified, with an incremented population number
}
\description{
Cross with random mating, or equal contributions, or randomly between two populations
}
\seealso{
\code{\link{defineSpecies}} for an example
}
