/*
 * BoxPlot.java
 *
 * Created on September 27, 2005, 6:33 PM
 */

package org.neptuneinc.cadstat.plots;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

/**
 *
 * @author  Pasha Minallah
 */
public class BoxPlot extends JDialog
{

  /** Creates new form BoxPlot */
  public BoxPlot()
  {
    this.initComponents();
    
    datasetPane.getDatasetLabel().setText("Active Dataset:");
    datasetPane.getDatasetComboBox().addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });
    datasetPane.refreshDatasetComboBox();
    this.refreshVariableListValidity();
    this.refreshGroupByComponentValidity();
    this.refreshSubmitButtonValidity();
    
    this.getRootPane().setDefaultButton(submitButton);
  }
  
  private void datasetComboBoxActionPerformed(ActionEvent evt)
  {
    this.refreshVariableList();
    this.factorSubsetPane.setDataset(datasetPane.getSelectedDataset());
    this.refreshGroupByComponentValidity();
    this.refreshSubmitButtonValidity();
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        plotTypeGroup = new javax.swing.ButtonGroup();
        datasetPane = new org.neptuneinc.cadstat.ui.DatasetPane();
        midPane = new javax.swing.JPanel();
        varPane = new javax.swing.JPanel();
        resultLabel = new javax.swing.JLabel();
        resultComboBox = new javax.swing.JComboBox();
        groupByPane = new javax.swing.JPanel();
        enableGroupByCheckBox = new javax.swing.JCheckBox();
        factorSubsetPane = new org.neptuneinc.cadstat.ui.FactorSubsetPane();
        plotTypePane = new javax.swing.JPanel();
        originalPlotTypeRadioButton = new javax.swing.JRadioButton();
        logPlotTypeRadioButton = new javax.swing.JRadioButton();
        bothPlotTypeRadioButton = new javax.swing.JRadioButton();
        plotOptionsPane = new javax.swing.JPanel();
        sampleSizes = new javax.swing.JCheckBox();
        rotateXLabCheckBox = new javax.swing.JCheckBox();
        horizontal = new javax.swing.JCheckBox();
        plotLabelsPane = new javax.swing.JPanel();
        plotTitleLabel = new javax.swing.JLabel();
        plotTitle = new javax.swing.JTextField();
        yAxisLabel = new javax.swing.JLabel();
        yAxis = new javax.swing.JTextField();
        buttonPane = new javax.swing.JPanel();
        cancelButton = new javax.swing.JButton();
        submitButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();
        datasetSeparator = new javax.swing.JSeparator();
        jSeparator1 = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Boxplot");

        varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

        resultLabel.setText("Result:");

        org.jdesktop.layout.GroupLayout varPaneLayout = new org.jdesktop.layout.GroupLayout(varPane);
        varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(resultLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(resultComboBox, 0, 191, Short.MAX_VALUE)
                .addContainerGap())
        );
        varPaneLayout.setVerticalGroup(
            varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(varPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(varPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(resultLabel)
                    .add(resultComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(14, Short.MAX_VALUE))
        );

        groupByPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Group By"));

        enableGroupByCheckBox.setText("Enable Grouping");
        enableGroupByCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                enableGroupByCheckBoxStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout groupByPaneLayout = new org.jdesktop.layout.GroupLayout(groupByPane);
        groupByPane.setLayout(groupByPaneLayout);
        groupByPaneLayout.setHorizontalGroup(
            groupByPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(groupByPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(groupByPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(factorSubsetPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(enableGroupByCheckBox))
                .addContainerGap(25, Short.MAX_VALUE))
        );
        groupByPaneLayout.setVerticalGroup(
            groupByPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(groupByPaneLayout.createSequentialGroup()
                .add(enableGroupByCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(factorSubsetPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 167, Short.MAX_VALUE)
                .addContainerGap())
        );

        plotTypePane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Type"));

        plotTypeGroup.add(originalPlotTypeRadioButton);
        originalPlotTypeRadioButton.setText("Original");

        plotTypeGroup.add(logPlotTypeRadioButton);
        logPlotTypeRadioButton.setText("Log");

        plotTypeGroup.add(bothPlotTypeRadioButton);
        bothPlotTypeRadioButton.setSelected(true);
        bothPlotTypeRadioButton.setText("Both");

        org.jdesktop.layout.GroupLayout plotTypePaneLayout = new org.jdesktop.layout.GroupLayout(plotTypePane);
        plotTypePane.setLayout(plotTypePaneLayout);
        plotTypePaneLayout.setHorizontalGroup(
            plotTypePaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotTypePaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(plotTypePaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(originalPlotTypeRadioButton)
                    .add(logPlotTypeRadioButton)
                    .add(bothPlotTypeRadioButton))
                .addContainerGap(182, Short.MAX_VALUE))
        );
        plotTypePaneLayout.setVerticalGroup(
            plotTypePaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotTypePaneLayout.createSequentialGroup()
                .add(originalPlotTypeRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(logPlotTypeRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bothPlotTypeRadioButton)
                .addContainerGap(10, Short.MAX_VALUE))
        );

        plotOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Options"));

        sampleSizes.setText("Sample Sizes");

        rotateXLabCheckBox.setText("Rotate X-Axis Labels");

        horizontal.setText("Horizontal Boxplot");
        horizontal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                horizontalActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout plotOptionsPaneLayout = new org.jdesktop.layout.GroupLayout(plotOptionsPane);
        plotOptionsPane.setLayout(plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup(
            plotOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotOptionsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(plotOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(sampleSizes)
                    .add(rotateXLabCheckBox)
                    .add(horizontal))
                .addContainerGap(118, Short.MAX_VALUE))
        );
        plotOptionsPaneLayout.setVerticalGroup(
            plotOptionsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, plotOptionsPaneLayout.createSequentialGroup()
                .add(horizontal)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(sampleSizes)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(rotateXLabCheckBox)
                .addContainerGap())
        );

        plotLabelsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Plot Labels"));

        plotTitleLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        plotTitleLabel.setLabelFor(plotTitle);
        plotTitleLabel.setText("Plot Title");

        plotTitle.setColumns(10);
        plotTitle.setText("Boxplot");

        yAxisLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        yAxisLabel.setLabelFor(yAxis);
        yAxisLabel.setText("Result-Axis");

        yAxis.setColumns(10);
        yAxis.setText("Y");

        org.jdesktop.layout.GroupLayout plotLabelsPaneLayout = new org.jdesktop.layout.GroupLayout(plotLabelsPane);
        plotLabelsPane.setLayout(plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup(
            plotLabelsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotLabelsPaneLayout.createSequentialGroup()
                .addContainerGap()
                .add(plotLabelsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(plotLabelsPaneLayout.createSequentialGroup()
                        .add(plotTitleLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 171, Short.MAX_VALUE))
                    .add(plotLabelsPaneLayout.createSequentialGroup()
                        .add(yAxisLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(yAxis, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 171, Short.MAX_VALUE)))
                .addContainerGap())
        );

        plotLabelsPaneLayout.linkSize(new java.awt.Component[] {plotTitleLabel, yAxisLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        plotLabelsPaneLayout.setVerticalGroup(
            plotLabelsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(plotLabelsPaneLayout.createSequentialGroup()
                .add(plotLabelsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(plotTitleLabel)
                    .add(plotTitle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotLabelsPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(yAxisLabel)
                    .add(yAxis, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(14, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout midPaneLayout = new org.jdesktop.layout.GroupLayout(midPane);
        midPane.setLayout(midPaneLayout);
        midPaneLayout.setHorizontalGroup(
            midPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(midPaneLayout.createSequentialGroup()
                .add(midPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(groupByPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(varPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(midPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(plotTypePane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(plotLabelsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(plotOptionsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        midPaneLayout.linkSize(new java.awt.Component[] {groupByPane, plotLabelsPane, plotOptionsPane, plotTypePane, varPane}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        midPaneLayout.setVerticalGroup(
            midPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(midPaneLayout.createSequentialGroup()
                .add(midPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(midPaneLayout.createSequentialGroup()
                        .add(varPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(groupByPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(midPaneLayout.createSequentialGroup()
                        .add(plotTypePane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotOptionsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(plotLabelsPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        submitButton.setText("Submit");
        submitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitButtonActionPerformed(evt);
            }
        });

        helpButton.setText("Help");
        helpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout buttonPaneLayout = new org.jdesktop.layout.GroupLayout(buttonPane);
        buttonPane.setLayout(buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup(
            buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(buttonPaneLayout.createSequentialGroup()
                .add(160, 160, 160)
                .add(cancelButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(submitButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(helpButton)
                .addContainerGap(193, Short.MAX_VALUE))
        );
        buttonPaneLayout.setVerticalGroup(
            buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(buttonPaneLayout.createSequentialGroup()
                .add(buttonPaneLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(submitButton)
                    .add(helpButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, datasetSeparator, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 578, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .add(111, 111, 111)
                .add(datasetPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(160, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(midPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(30, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 558, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(buttonPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(20, 20, 20))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(datasetPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(datasetSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(midPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(buttonPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(12, 12, 12))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
  this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

private void submitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
  PreferencesManager prefsManager = new PreferencesManager();

  try
  {
    prefsManager.importPreferences();
  }
  catch (Exception ex)
  {
    Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
  }

  String plotType = "both";

  if (originalPlotTypeRadioButton.isSelected())
  {
    plotType = "original";
  }

  else if (logPlotTypeRadioButton.isSelected())
  {
    plotType = "log";
  }

  else if (bothPlotTypeRadioButton.isSelected())
  {
    plotType = "both";
  }

//    getFactorSelectionPane1().getSelectedFactorValues()
  String cmd = "boxplot.JGR("
    + "x=" + datasetPane.getSelectedDataset()
    + ", result=" + "'" + GUIUtils.getSelectedItem(resultComboBox) + "'"
    + ", group.name=" + (enableGroupByCheckBox.isSelected() ? "'" + factorSubsetPane.getSelectedFactor() + "'" : "NULL")
    + ", group.val=" + "c(" + RUtils.toString(this.factorSubsetPane.getSelectedFactorValues(), ",", "'") + ")"
    + ", subset1.name=" + "NULL"
    + ", subset1.val=" + "NULL"
    + ", subset2.name=" + "NULL"
    + ", subset2.val=" + "NULL"
    + ", main=" + "'" + plotTitle.getText() + "'"
    + ", result.lab=" + "'" + yAxis.getText() + "'"
    + ", plot.type=" + "'" + plotType + "'"
    + ", horizontal=" + String.valueOf(horizontal.isSelected()).toUpperCase()
    + ", iSampleSize=" + String.valueOf(sampleSizes.isSelected()).toUpperCase()
    + ", names.rot=" + String.valueOf(rotateXLabCheckBox.isSelected()).toUpperCase()
    + ", " + prefsManager.getCadstatPreferences().toString()
    + ")";
  JGR.MAINRCONSOLE.execute(cmd, true);
}//GEN-LAST:event_submitButtonActionPerformed

private void helpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
  String cmd = "CADStat.help('boxplot.JGR')";
  JGR.MAINRCONSOLE.execute(cmd, true);
}//GEN-LAST:event_helpButtonActionPerformed

private void enableGroupByCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_enableGroupByCheckBoxStateChanged
  this.refreshGroupByComponentValidity();
  this.refreshSubmitButtonValidity();
}//GEN-LAST:event_enableGroupByCheckBoxStateChanged

private void horizontalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_horizontalActionPerformed
  this.refreshSampleSizes();
}//GEN-LAST:event_horizontalActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton bothPlotTypeRadioButton;
    private javax.swing.JPanel buttonPane;
    private javax.swing.JButton cancelButton;
    private org.neptuneinc.cadstat.ui.DatasetPane datasetPane;
    private javax.swing.JSeparator datasetSeparator;
    private javax.swing.JCheckBox enableGroupByCheckBox;
    private org.neptuneinc.cadstat.ui.FactorSubsetPane factorSubsetPane;
    private javax.swing.JPanel groupByPane;
    private javax.swing.JButton helpButton;
    private javax.swing.JCheckBox horizontal;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton logPlotTypeRadioButton;
    private javax.swing.JPanel midPane;
    private javax.swing.JRadioButton originalPlotTypeRadioButton;
    private javax.swing.JPanel plotLabelsPane;
    private javax.swing.JPanel plotOptionsPane;
    private javax.swing.JTextField plotTitle;
    private javax.swing.JLabel plotTitleLabel;
    private javax.swing.ButtonGroup plotTypeGroup;
    private javax.swing.JPanel plotTypePane;
    private javax.swing.JComboBox resultComboBox;
    private javax.swing.JLabel resultLabel;
    private javax.swing.JCheckBox rotateXLabCheckBox;
    private javax.swing.JCheckBox sampleSizes;
    private javax.swing.JButton submitButton;
    private javax.swing.JPanel varPane;
    private javax.swing.JTextField yAxis;
    private javax.swing.JLabel yAxisLabel;
    // End of variables declaration//GEN-END:variables

  public void refreshVariableListValidity()
  {
    resultComboBox.setEnabled(datasetPane.getDatasetComboBox().getItemCount() > 0 && resultComboBox.getItemCount() > 0);
  }
  
  public void refreshSampleSizes()
  {
    sampleSizes.setSelected(!horizontal.isSelected() && sampleSizes.isSelected());
    sampleSizes.setEnabled(!horizontal.isSelected());
  }
  
  public void refreshVariableList()
  {
    if (datasetPane.getDatasetComboBox().getItemCount() > 0)
    {
      Vector nonFactors = RUtils.nonFactors(datasetPane.getSelectedDataset());
      resultComboBox.setModel(new DefaultComboBoxModel(nonFactors));
      
      if (resultComboBox.getItemCount() > 0)
      {
        resultComboBox.setSelectedIndex(0);
      }
    }
    
    else
    {
      resultComboBox.removeAllItems();
    }
    
    this.refreshVariableListValidity();
    this.refreshSubmitButtonValidity();
  }
  
  public void refreshGroupByComponentValidity()
  {
    JLabel factorLabel = factorSubsetPane.getFactorLabel();
    JComboBox factorComboBox = factorSubsetPane.getFactorComboBox();
    JScrollPane factorValueScrollPane = factorSubsetPane.getFactorValueScrollPane();
    JList factorValueList = factorSubsetPane.getFactorValueList();
    
    boolean groupByEnabled = enableGroupByCheckBox.isSelected();
    
    factorLabel.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
    factorComboBox.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
    factorValueScrollPane.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
    factorValueList.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
  }
  
  public void refreshSubmitButtonValidity()
  {
    JComboBox factorComboBox = factorSubsetPane.getFactorComboBox();
    
    submitButton.setEnabled(datasetPane.getDatasetComboBox().getItemCount() > 0 && resultComboBox.getItemCount() > 0 &&
      (enableGroupByCheckBox.isSelected() ? factorComboBox.getItemCount() > 0 : true));
  }
  
}
