% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calf_wrappers.R
\name{calf_subset}
\alias{calf_subset}
\title{calf_subset}
\usage{
calf_subset(data, nMarkers, proportion = 0.8, times = 1)
}
\arguments{
\item{data}{Matrix or data frame. First column must contain case/control dummy coded variable; all other columns contain relevant markers}

\item{nMarkers}{Maximum number of markers to include in creation of sum}

\item{proportion}{Numeric. A value (where 0 < proportion <= 1) indicating the proportion of cases and controls to use in analysis. Used to evaluate robustness of solution. Defaults to 0.8.}

\item{times}{Numeric. Indicates the number of replications to run with randomization.}
}
\value{
A data frame containing the chosen markers and their assigned weight (-1 or 1)

The AUC value for the classification. If multiple replications are requested, this will be a data.frame containing all AUCs across replications.

aucHist A histogram of the AUCs across replications.
}
\description{
Coarse approximation linear function, randomized
}
\examples{
calf_subset(data = CaseControl, nMarkers = 6, times = 5)
}

