// Generated by rstantools.  Do not edit by hand.

/*
    CARME is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CARME is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CARME.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_CARMM_COV_P_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 84, column 2 to column 35)",
                                                      " (in 'string', line 85, column 2 to column 22)",
                                                      " (in 'string', line 86, column 2 to column 21)",
                                                      " (in 'string', line 88, column 2 to column 13)",
                                                      " (in 'string', line 89, column 2 to column 17)",
                                                      " (in 'string', line 92, column 2 to column 17)",
                                                      " (in 'string', line 93, column 2 to column 27)",
                                                      " (in 'string', line 94, column 2 to column 16)",
                                                      " (in 'string', line 95, column 2 to column 27)",
                                                      " (in 'string', line 96, column 2 to column 26)",
                                                      " (in 'string', line 98, column 2 to column 40)",
                                                      " (in 'string', line 109, column 2 to column 25)",
                                                      " (in 'string', line 110, column 2 to column 20)",
                                                      " (in 'string', line 111, column 2 to column 24)",
                                                      " (in 'string', line 112, column 2 to column 14)",
                                                      " (in 'string', line 113, column 2 to column 18)",
                                                      " (in 'string', line 114, column 2 to column 11)",
                                                      " (in 'string', line 115, column 2 to column 17)",
                                                      " (in 'string', line 117, column 3 to column 37)",
                                                      " (in 'string', line 121, column 4 to column 67)",
                                                      " (in 'string', line 123, column 4 to column 56)",
                                                      " (in 'string', line 125, column 4 to column 74)",
                                                      " (in 'string', line 119, column 17 to line 126, column 3)",
                                                      " (in 'string', line 119, column 2 to line 126, column 3)",
                                                      " (in 'string', line 128, column 4 to column 26)",
                                                      " (in 'string', line 129, column 4 to column 34)",
                                                      " (in 'string', line 131, column 4 to column 38)",
                                                      " (in 'string', line 101, column 2 to column 67)",
                                                      " (in 'string', line 102, column 2 to column 35)",
                                                      " (in 'string', line 103, column 2 to column 37)",
                                                      " (in 'string', line 104, column 2 to column 40)",
                                                      " (in 'string', line 106, column 2 to column 38)",
                                                      " (in 'string', line 31, column 2 to column 17)",
                                                      " (in 'string', line 33, column 2 to column 17)",
                                                      " (in 'string', line 34, column 9 to column 10)",
                                                      " (in 'string', line 34, column 12 to column 13)",
                                                      " (in 'string', line 34, column 2 to column 17)",
                                                      " (in 'string', line 36, column 31 to column 32)",
                                                      " (in 'string', line 36, column 34 to column 35)",
                                                      " (in 'string', line 36, column 2 to column 39)",
                                                      " (in 'string', line 37, column 2 to column 10)",
                                                      " (in 'string', line 39, column 2 to column 17)",
                                                      " (in 'string', line 40, column 9 to column 10)",
                                                      " (in 'string', line 40, column 12 to column 13)",
                                                      " (in 'string', line 40, column 2 to column 21)",
                                                      " (in 'string', line 42, column 19 to column 20)",
                                                      " (in 'string', line 42, column 2 to column 22)",
                                                      " (in 'string', line 44, column 9 to column 10)",
                                                      " (in 'string', line 44, column 2 to column 23)",
                                                      " (in 'string', line 46, column 2 to column 16)",
                                                      " (in 'string', line 47, column 2 to column 15)",
                                                      " (in 'string', line 48, column 2 to column 30)",
                                                      " (in 'string', line 49, column 2 to column 29)",
                                                      " (in 'string', line 50, column 2 to column 28)",
                                                      " (in 'string', line 51, column 2 to column 27)",
                                                      " (in 'string', line 56, column 9 to column 10)",
                                                      " (in 'string', line 56, column 2 to column 16)",
                                                      " (in 'string', line 57, column 15 to column 18)",
                                                      " (in 'string', line 57, column 2 to column 23)",
                                                      " (in 'string', line 58, column 9 to column 10)",
                                                      " (in 'string', line 58, column 2 to column 21)",
                                                      " (in 'string', line 59, column 9 to column 10)",
                                                      " (in 'string', line 59, column 2 to column 19)",
                                                      " (in 'string', line 61, column 2 to column 14)",
                                                      " (in 'string', line 62, column 2 to column 14)",
                                                      " (in 'string', line 67, column 10 to column 35)",
                                                      " (in 'string', line 68, column 10 to column 35)",
                                                      " (in 'string', line 69, column 10 to column 32)",
                                                      " (in 'string', line 66, column 26 to line 70, column 9)",
                                                      " (in 'string', line 66, column 8 to line 70, column 9)",
                                                      " (in 'string', line 65, column 27 to line 71, column 7)",
                                                      " (in 'string', line 65, column 6 to line 71, column 7)",
                                                      " (in 'string', line 64, column 25 to line 72, column 5)",
                                                      " (in 'string', line 64, column 4 to line 72, column 5)",
                                                      " (in 'string', line 60, column 2 to line 73, column 3)",
                                                      " (in 'string', line 74, column 17 to column 41)",
                                                      " (in 'string', line 74, column 2 to column 41)",
                                                      " (in 'string', line 76, column 11 to column 12)",
                                                      " (in 'string', line 76, column 4 to column 23)",
                                                      " (in 'string', line 78, column 6 to column 42)",
                                                      " (in 'string', line 77, column 19 to line 79, column 5)",
                                                      " (in 'string', line 77, column 4 to line 79, column 5)",
                                                      " (in 'string', line 80, column 4 to column 66)",
                                                      " (in 'string', line 75, column 2 to line 81, column 3)",
                                                      " (in 'string', line 86, column 9 to column 10)",
                                                      " (in 'string', line 89, column 9 to column 10)",
                                                      " (in 'string', line 92, column 9 to column 10)",
                                                      " (in 'string', line 94, column 9 to column 10)",
                                                      " (in 'string', line 109, column 22 to column 23)",
                                                      " (in 'string', line 110, column 9 to column 10)",
                                                      " (in 'string', line 111, column 9 to column 10)",
                                                      " (in 'string', line 115, column 9 to column 10)",
                                                      " (in 'string', line 5, column 17 to column 18)",
                                                      " (in 'string', line 5, column 6 to column 27)",
                                                      " (in 'string', line 6, column 17 to column 18)",
                                                      " (in 'string', line 6, column 6 to column 27)",
                                                      " (in 'string', line 7, column 13 to column 14)",
                                                      " (in 'string', line 7, column 6 to column 27)",
                                                      " (in 'string', line 8, column 6 to column 34)",
                                                      " (in 'string', line 9, column 6 to column 36)",
                                                      " (in 'string', line 11, column 8 to column 78)",
                                                      " (in 'string', line 12, column 8 to column 78)",
                                                      " (in 'string', line 10, column 23 to line 13, column 7)",
                                                      " (in 'string', line 10, column 6 to line 13, column 7)",
                                                      " (in 'string', line 14, column 21 to column 62)",
                                                      " (in 'string', line 14, column 6 to column 62)",
                                                      " (in 'string', line 15, column 6 to column 79)",
                                                      " (in 'string', line 4, column 69 to line 16, column 3)",
                                                      " (in 'string', line 18, column 4 to column 14)",
                                                      " (in 'string', line 19, column 4 to column 13)",
                                                      " (in 'string', line 20, column 4 to column 15)",
                                                      " (in 'string', line 21, column 4 to column 15)",
                                                      " (in 'string', line 22, column 4 to column 14)",
                                                      " (in 'string', line 23, column 4 to column 44)",
                                                      " (in 'string', line 24, column 4 to column 53)",
                                                      " (in 'string', line 25, column 4 to column 53)",
                                                      " (in 'string', line 26, column 4 to column 31)",
                                                      " (in 'string', line 17, column 42 to line 27, column 5)"};
template <bool propto__, typename T0__, typename T1__, typename T3__,
typename T4__>
stan::promote_args_t<stan::value_type_t<T0__>, T1__,
stan::value_type_t<T3__>,
stan::value_type_t<T4__>>
sparse_car_lpdf(const T0__& phi_arg__, const T1__& alpha,
                const std::vector<std::vector<int>>& W_sparse,
                const T3__& D_sparse_arg__, const T4__& lambda_arg__,
                const int& n, const int& W_n, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>>;
  const auto& phi = to_ref(phi_arg__);
  const auto& D_sparse = to_ref(D_sparse_arg__);
  const auto& lambda = to_ref(lambda_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 93;
    validate_non_negative_index("phit_D", "n", n);
    Eigen::Matrix<local_scalar_t__, 1, -1> phit_D;
    phit_D = Eigen::Matrix<local_scalar_t__, 1, -1>(n);
    stan::math::fill(phit_D, DUMMY_VAR__);
    
    current_statement__ = 95;
    validate_non_negative_index("phit_W", "n", n);
    Eigen::Matrix<local_scalar_t__, 1, -1> phit_W;
    phit_W = Eigen::Matrix<local_scalar_t__, 1, -1>(n);
    stan::math::fill(phit_W, DUMMY_VAR__);
    
    current_statement__ = 97;
    validate_non_negative_index("ldet_terms", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> ldet_terms;
    ldet_terms = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(ldet_terms, DUMMY_VAR__);
    
    current_statement__ = 99;
    assign(phit_D, nil_index_list(), transpose(elt_multiply(phi, D_sparse)),
      "assigning variable phit_D");
    current_statement__ = 100;
    assign(phit_W, nil_index_list(), rep_row_vector(0, n),
      "assigning variable phit_W");
    current_statement__ = 104;
    for (int i = 1; i <= W_n; ++i) {
      current_statement__ = 101;
      assign(phit_W,
        cons_list(index_uni(W_sparse[(i - 1)][(1 - 1)]), nil_index_list()),
        (phit_W[(W_sparse[(i - 1)][(1 - 1)] - 1)] +
          phi[(W_sparse[(i - 1)][(2 - 1)] - 1)]), "assigning variable phit_W");
      current_statement__ = 102;
      assign(phit_W,
        cons_list(index_uni(W_sparse[(i - 1)][(2 - 1)]), nil_index_list()),
        (phit_W[(W_sparse[(i - 1)][(2 - 1)] - 1)] +
          phi[(W_sparse[(i - 1)][(1 - 1)] - 1)]), "assigning variable phit_W");
    }
    current_statement__ = 106;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 105;
      assign(ldet_terms, cons_list(index_uni(i), nil_index_list()),
        log1m((alpha * lambda[(i - 1)])), "assigning variable ldet_terms");}
    current_statement__ = 107;
    return (0.5 *
             (sum(ldet_terms) -
               (multiply(phit_D, phi) - (alpha * multiply(phit_W, phi)))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct sparse_car_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T3__,
typename T4__>
stan::promote_args_t<stan::value_type_t<T0__>, T1__,
stan::value_type_t<T3__>,
stan::value_type_t<T4__>>
operator()(const T0__& phi, const T1__& alpha,
           const std::vector<std::vector<int>>& W_sparse,
           const T3__& D_sparse, const T4__& lambda, const int& n,
           const int& W_n, std::ostream* pstream__)  const 
{
return sparse_car_lpdf<propto__>(phi, alpha, W_sparse, D_sparse, lambda, n,
         W_n, pstream__);
}
};
template <typename T0__, typename T1__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>
corr_val(const T0__& x_arg__, const T1__& y_arg__, const int& n,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& x = to_ref(x_arg__);
  const auto& y = to_ref(y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n_vec;
    n_vec = std::numeric_limits<int>::min();
    
    local_scalar_t__ num;
    num = DUMMY_VAR__;
    
    local_scalar_t__ den_1;
    den_1 = DUMMY_VAR__;
    
    local_scalar_t__ den_2;
    den_2 = DUMMY_VAR__;
    
    current_statement__ = 113;
    n_vec = n;
    current_statement__ = 114;
    num = ((n_vec * sum(elt_multiply(x, y))) - (sum(x) * sum(y)));
    current_statement__ = 115;
    den_1 = stan::math::sqrt(
              ((n_vec * sum(elt_multiply(x, x))) - pow(sum(x), 2)));
    current_statement__ = 116;
    den_2 = stan::math::sqrt(
              ((n_vec * sum(elt_multiply(y, y))) - pow(sum(y), 2)));
    current_statement__ = 117;
    return (num / (den_1 * den_2));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct corr_val_functor__ {
template <typename T0__, typename T1__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>
operator()(const T0__& x, const T1__& y, const int& n,
           std::ostream* pstream__)  const 
{
return corr_val(x, y, n, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_CARMM_COV_P final : public model_base_crtp<model_CARMM_COV_P> {
private:
  int n;
  int m;
  Eigen::Matrix<double, -1, -1> H;
  Eigen::Matrix<double, -1, -1> W;
  int W_n;
  int k;
  Eigen::Matrix<double, -1, -1> X_cov;
  std::vector<int> y;
  Eigen::Matrix<double, -1, 1> log_offset;
  double mu_gamma;
  double mu_beta;
  double sigma_gamma;
  double sigma_beta;
  double tau_shape;
  double tau_rate;
  Eigen::Matrix<double, -1, 1> n_i;
  std::vector<std::vector<int>> W_sparse;
  Eigen::Matrix<double, -1, 1> D_sparse;
  Eigen::Matrix<double, -1, 1> lambda;
 
public:
  ~model_CARMM_COV_P() { }
  
  inline std::string model_name() const final { return "model_CARMM_COV_P"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_CARMM_COV_P(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_CARMM_COV_P_namespace::model_CARMM_COV_P";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 33;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 33;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 33;
      current_statement__ = 33;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 34;
      context__.validate_dims("data initialization","m","int",
          context__.to_vec());
      m = std::numeric_limits<int>::min();
      
      current_statement__ = 34;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 34;
      current_statement__ = 34;
      check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 35;
      validate_non_negative_index("H", "m", m);
      current_statement__ = 36;
      validate_non_negative_index("H", "n", n);
      current_statement__ = 37;
      context__.validate_dims("data initialization","H","double",
          context__.to_vec(m, n));
      H = Eigen::Matrix<double, -1, -1>(m, n);
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> H_flat__;
        current_statement__ = 37;
        assign(H_flat__, nil_index_list(), context__.vals_r("H"),
          "assigning variable H_flat__");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 37;
          for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
            current_statement__ = 37;
            assign(H,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              H_flat__[(pos__ - 1)], "assigning variable H");
            current_statement__ = 37;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 38;
      validate_non_negative_index("W", "n", n);
      current_statement__ = 39;
      validate_non_negative_index("W", "n", n);
      current_statement__ = 40;
      context__.validate_dims("data initialization","W","double",
          context__.to_vec(n, n));
      W = Eigen::Matrix<double, -1, -1>(n, n);
      stan::math::fill(W, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> W_flat__;
        current_statement__ = 40;
        assign(W_flat__, nil_index_list(), context__.vals_r("W"),
          "assigning variable W_flat__");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 40;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 40;
            assign(W,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              W_flat__[(pos__ - 1)], "assigning variable W");
            current_statement__ = 40;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 40;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 40;
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          current_statement__ = 40;
          current_statement__ = 40;
          check_greater_or_equal(function__, "W[sym1__, sym2__]",
                                 rvalue(W,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "W"), 0);}}
      current_statement__ = 40;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 40;
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          current_statement__ = 40;
          current_statement__ = 40;
          check_less_or_equal(function__, "W[sym1__, sym2__]",
                              rvalue(W,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "W"), 1);}}
      current_statement__ = 41;
      context__.validate_dims("data initialization","W_n","int",
          context__.to_vec());
      W_n = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      W_n = context__.vals_i("W_n")[(1 - 1)];
      current_statement__ = 42;
      context__.validate_dims("data initialization","k","int",
          context__.to_vec());
      k = std::numeric_limits<int>::min();
      
      current_statement__ = 42;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 42;
      current_statement__ = 42;
      check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 43;
      validate_non_negative_index("X_cov", "n", n);
      current_statement__ = 44;
      validate_non_negative_index("X_cov", "k", k);
      current_statement__ = 45;
      context__.validate_dims("data initialization","X_cov","double",
          context__.to_vec(n, k));
      X_cov = Eigen::Matrix<double, -1, -1>(n, k);
      stan::math::fill(X_cov, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_cov_flat__;
        current_statement__ = 45;
        assign(X_cov_flat__, nil_index_list(), context__.vals_r("X_cov"),
          "assigning variable X_cov_flat__");
        current_statement__ = 45;
        pos__ = 1;
        current_statement__ = 45;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 45;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 45;
            assign(X_cov,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_cov_flat__[(pos__ - 1)], "assigning variable X_cov");
            current_statement__ = 45;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 46;
      validate_non_negative_index("y", "m", m);
      current_statement__ = 47;
      context__.validate_dims("data initialization","y","int",
          context__.to_vec(m));
      y = std::vector<int>(m, std::numeric_limits<int>::min());
      
      current_statement__ = 47;
      assign(y, nil_index_list(), context__.vals_i("y"),
        "assigning variable y");
      current_statement__ = 47;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 47;
        current_statement__ = 47;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 48;
      validate_non_negative_index("log_offset", "m", m);
      current_statement__ = 49;
      context__.validate_dims("data initialization","log_offset","double",
          context__.to_vec(m));
      log_offset = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(log_offset, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log_offset_flat__;
        current_statement__ = 49;
        assign(log_offset_flat__, nil_index_list(),
          context__.vals_r("log_offset"),
          "assigning variable log_offset_flat__");
        current_statement__ = 49;
        pos__ = 1;
        current_statement__ = 49;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 49;
          assign(log_offset, cons_list(index_uni(sym1__), nil_index_list()),
            log_offset_flat__[(pos__ - 1)], "assigning variable log_offset");
          current_statement__ = 49;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 50;
      context__.validate_dims("data initialization","mu_gamma","double",
          context__.to_vec());
      mu_gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 50;
      mu_gamma = context__.vals_r("mu_gamma")[(1 - 1)];
      current_statement__ = 51;
      context__.validate_dims("data initialization","mu_beta","double",
          context__.to_vec());
      mu_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 51;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      current_statement__ = 52;
      context__.validate_dims("data initialization","sigma_gamma","double",
          context__.to_vec());
      sigma_gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 52;
      sigma_gamma = context__.vals_r("sigma_gamma")[(1 - 1)];
      current_statement__ = 52;
      current_statement__ = 52;
      check_greater_or_equal(function__, "sigma_gamma", sigma_gamma, 0);
      current_statement__ = 53;
      context__.validate_dims("data initialization","sigma_beta","double",
          context__.to_vec());
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 53;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "sigma_beta", sigma_beta, 0);
      current_statement__ = 54;
      context__.validate_dims("data initialization","tau_shape","double",
          context__.to_vec());
      tau_shape = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 54;
      tau_shape = context__.vals_r("tau_shape")[(1 - 1)];
      current_statement__ = 54;
      current_statement__ = 54;
      check_greater_or_equal(function__, "tau_shape", tau_shape, 0);
      current_statement__ = 55;
      context__.validate_dims("data initialization","tau_rate","double",
          context__.to_vec());
      tau_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 55;
      tau_rate = context__.vals_r("tau_rate")[(1 - 1)];
      current_statement__ = 55;
      current_statement__ = 55;
      check_greater_or_equal(function__, "tau_rate", tau_rate, 0);
      current_statement__ = 56;
      validate_non_negative_index("n_i", "n", n);
      current_statement__ = 57;
      n_i = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(n_i, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 58;
      validate_non_negative_index("W_sparse", "W_n", W_n);
      current_statement__ = 59;
      W_sparse = std::vector<std::vector<int>>(W_n, std::vector<int>(2, std::numeric_limits<int>::min()));
      
      current_statement__ = 60;
      validate_non_negative_index("D_sparse", "n", n);
      current_statement__ = 61;
      D_sparse = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(D_sparse, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 62;
      validate_non_negative_index("lambda", "n", n);
      current_statement__ = 63;
      lambda = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(lambda, std::numeric_limits<double>::quiet_NaN());
      
      {
        int counter;
        counter = std::numeric_limits<int>::min();
        
        current_statement__ = 65;
        counter = 1;
        current_statement__ = 74;
        for (int i = 1; i <= (n - 1); ++i) {
          current_statement__ = 72;
          for (int j = (i + 1); j <= n; ++j) {
            current_statement__ = 70;
            if (logical_eq(
                  rvalue(W,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "W"), 1)) {
              current_statement__ = 66;
              assign(W_sparse,
                cons_list(index_uni(counter),
                  cons_list(index_uni(1), nil_index_list())), i,
                "assigning variable W_sparse");
              current_statement__ = 67;
              assign(W_sparse,
                cons_list(index_uni(counter),
                  cons_list(index_uni(2), nil_index_list())), j,
                "assigning variable W_sparse");
              current_statement__ = 68;
              counter = (counter + 1);
            } }}
      }
      current_statement__ = 77;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 76;
        assign(D_sparse, cons_list(index_uni(i), nil_index_list()),
          sum(rvalue(W, cons_list(index_uni(i), nil_index_list()), "W")),
          "assigning variable D_sparse");}
      {
        current_statement__ = 78;
        validate_non_negative_index("invsqrtD", "n", n);
        Eigen::Matrix<double, -1, 1> invsqrtD;
        invsqrtD = Eigen::Matrix<double, -1, 1>(n);
        stan::math::fill(invsqrtD, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 82;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 80;
          assign(invsqrtD, cons_list(index_uni(i), nil_index_list()),
            (1 / stan::math::sqrt(D_sparse[(i - 1)])),
            "assigning variable invsqrtD");}
        current_statement__ = 83;
        assign(lambda, nil_index_list(),
          eigenvalues_sym(quad_form(W, diag_matrix(invsqrtD))),
          "assigning variable lambda");
      }
      current_statement__ = 85;
      validate_non_negative_index("phi_unsc", "n", n);
      current_statement__ = 86;
      validate_non_negative_index("beta", "k", k);
      current_statement__ = 87;
      validate_non_negative_index("r_mm", "m", m);
      current_statement__ = 88;
      validate_non_negative_index("phi", "n", n);
      current_statement__ = 89;
      validate_non_negative_index("yrep", "m", m);
      current_statement__ = 90;
      validate_non_negative_index("log_lik", "m", m);
      current_statement__ = 91;
      validate_non_negative_index("log_lik_rep", "m", m);
      current_statement__ = 92;
      validate_non_negative_index("l_RR", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += n;
      num_params_r__ += 1;
      num_params_r__ += k;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_CARMM_COV_P_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ alpha;
      alpha = DUMMY_VAR__;
      
      current_statement__ = 1;
      alpha = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        alpha = stan::math::lub_constrain(alpha, 0, 1, lp__);
      } else {
        current_statement__ = 1;
        alpha = stan::math::lub_constrain(alpha, 0, 1);
      }
      local_scalar_t__ tau;
      tau = DUMMY_VAR__;
      
      current_statement__ = 2;
      tau = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        tau = stan::math::lb_constrain(tau, 0, lp__);
      } else {
        current_statement__ = 2;
        tau = stan::math::lb_constrain(tau, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> phi_unsc;
      phi_unsc = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(phi_unsc, DUMMY_VAR__);
      
      current_statement__ = 3;
      phi_unsc = in__.vector(n);
      local_scalar_t__ gamma;
      gamma = DUMMY_VAR__;
      
      current_statement__ = 4;
      gamma = in__.scalar();
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(k);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 5;
      beta = in__.vector(k);
      Eigen::Matrix<local_scalar_t__, -1, 1> r_mm;
      r_mm = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(r_mm, DUMMY_VAR__);
      
      local_scalar_t__ invtausq;
      invtausq = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 9;
      invtausq = inv_sqrt(tau);
      current_statement__ = 10;
      assign(phi, nil_index_list(), multiply(invtausq, phi_unsc),
        "assigning variable phi");
      current_statement__ = 11;
      assign(r_mm, nil_index_list(),
        multiply(H, add(add(gamma, multiply(X_cov, beta)), phi)),
        "assigning variable r_mm");
      current_statement__ = 7;
      current_statement__ = 7;
      check_greater_or_equal(function__, "invtausq", invtausq, 0);
      {
        current_statement__ = 28;
        lp_accum__.add(
          sparse_car_lpdf<propto__>(phi_unsc, alpha, W_sparse, D_sparse,
            lambda, n, W_n, pstream__));
        current_statement__ = 29;
        lp_accum__.add(gamma_lpdf<propto__>(tau, tau_shape, tau_rate));
        current_statement__ = 30;
        lp_accum__.add(normal_lpdf<propto__>(beta, mu_beta, sigma_beta));
        current_statement__ = 31;
        lp_accum__.add(normal_lpdf<propto__>(gamma, mu_gamma, sigma_gamma));
        current_statement__ = 32;
        lp_accum__.add(
          poisson_lpmf<propto__>(y, stan::math::exp(add(log_offset, r_mm))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_CARMM_COV_P_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double alpha;
      alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      alpha = in__.scalar();
      current_statement__ = 1;
      alpha = stan::math::lub_constrain(alpha, 0, 1);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau = in__.scalar();
      current_statement__ = 2;
      tau = stan::math::lb_constrain(tau, 0);
      Eigen::Matrix<double, -1, 1> phi_unsc;
      phi_unsc = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(phi_unsc, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      phi_unsc = in__.vector(n);
      double gamma;
      gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma = in__.scalar();
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      beta = in__.vector(k);
      Eigen::Matrix<double, -1, 1> r_mm;
      r_mm = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(r_mm, std::numeric_limits<double>::quiet_NaN());
      
      double invtausq;
      invtausq = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> phi;
      phi = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      vars__.emplace_back(alpha);
      vars__.emplace_back(tau);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(phi_unsc[(sym1__ - 1)]);}
      vars__.emplace_back(gamma);
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 9;
      invtausq = inv_sqrt(tau);
      current_statement__ = 10;
      assign(phi, nil_index_list(), multiply(invtausq, phi_unsc),
        "assigning variable phi");
      current_statement__ = 11;
      assign(r_mm, nil_index_list(),
        multiply(H, add(add(gamma, multiply(X_cov, beta)), phi)),
        "assigning variable r_mm");
      current_statement__ = 7;
      current_statement__ = 7;
      check_greater_or_equal(function__, "invtausq", invtausq, 0);
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          vars__.emplace_back(r_mm[(sym1__ - 1)]);}
        vars__.emplace_back(invtausq);
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(phi[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<int> yrep;
      yrep = std::vector<int>(m, std::numeric_limits<int>::min());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik_rep;
      log_lik_rep = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(log_lik_rep, std::numeric_limits<double>::quiet_NaN());
      
      double sum_ll;
      sum_ll = std::numeric_limits<double>::quiet_NaN();
      
      double sum_ll_rep;
      sum_ll_rep = std::numeric_limits<double>::quiet_NaN();
      
      double ppp;
      ppp = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> l_RR;
      l_RR = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(l_RR, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 19;
      assign(l_RR, nil_index_list(),
        add(add(gamma, multiply(X_cov, beta)), phi),
        "assigning variable l_RR");
      current_statement__ = 24;
      for (int i = 1; i <= m; ++i) {
        current_statement__ = 20;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          poisson_lpmf<false>(y[(i - 1)],
            stan::math::exp((r_mm[(i - 1)] + log_offset[(i - 1)]))),
          "assigning variable log_lik");
        current_statement__ = 21;
        assign(yrep, cons_list(index_uni(i), nil_index_list()),
          poisson_rng(stan::math::exp((r_mm[(i - 1)] + log_offset[(i - 1)])),
            base_rng__), "assigning variable yrep");
        current_statement__ = 22;
        assign(log_lik_rep, cons_list(index_uni(i), nil_index_list()),
          poisson_lpmf<false>(yrep[(i - 1)],
            stan::math::exp((r_mm[(i - 1)] + log_offset[(i - 1)]))),
          "assigning variable log_lik_rep");}
      current_statement__ = 25;
      sum_ll = sum(log_lik);
      current_statement__ = 26;
      sum_ll_rep = sum(log_lik_rep);
      current_statement__ = 27;
      ppp = (logical_gt(sum_ll, sum_ll_rep) ? 1 : 0);
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "yrep[sym1__]",
                               yrep[(sym1__ - 1)], 0);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(yrep[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(log_lik_rep[(sym1__ - 1)]);}
      vars__.emplace_back(sum_ll);
      vars__.emplace_back(sum_ll_rep);
      vars__.emplace_back(ppp);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(l_RR[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double alpha;
      alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      double alpha_free__;
      alpha_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      alpha_free__ = stan::math::lub_free(alpha, 0, 1);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau = context__.vals_r("tau")[(1 - 1)];
      double tau_free__;
      tau_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      tau_free__ = stan::math::lb_free(tau, 0);
      Eigen::Matrix<double, -1, 1> phi_unsc;
      phi_unsc = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(phi_unsc, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_unsc_flat__;
        current_statement__ = 3;
        assign(phi_unsc_flat__, nil_index_list(),
          context__.vals_r("phi_unsc"), "assigning variable phi_unsc_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          assign(phi_unsc, cons_list(index_uni(sym1__), nil_index_list()),
            phi_unsc_flat__[(pos__ - 1)], "assigning variable phi_unsc");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double gamma;
      gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma = context__.vals_r("gamma")[(1 - 1)];
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(k);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 5;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 5;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      vars__.emplace_back(alpha_free__);
      vars__.emplace_back(tau_free__);
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        vars__.emplace_back(phi_unsc[(sym1__ - 1)]);}
      vars__.emplace_back(gamma);
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha");
    names__.emplace_back("tau");
    names__.emplace_back("phi_unsc");
    names__.emplace_back("gamma");
    names__.emplace_back("beta");
    names__.emplace_back("r_mm");
    names__.emplace_back("invtausq");
    names__.emplace_back("phi");
    names__.emplace_back("yrep");
    names__.emplace_back("log_lik");
    names__.emplace_back("log_lik_rep");
    names__.emplace_back("sum_ll");
    names__.emplace_back("sum_ll_rep");
    names__.emplace_back("ppp");
    names__.emplace_back("l_RR");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(k)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "alpha");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi_unsc" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma");
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r_mm" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "invtausq");
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "yrep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik_rep" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "sum_ll");
      param_names__.emplace_back(std::string() + "sum_ll_rep");
      param_names__.emplace_back(std::string() + "ppp");
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l_RR" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "alpha");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi_unsc" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma");
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r_mm" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "invtausq");
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "yrep" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik_rep" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "sum_ll");
      param_names__.emplace_back(std::string() + "sum_ll_rep");
      param_names__.emplace_back(std::string() + "ppp");
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l_RR" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi_unsc\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"parameters\"},{\"name\":\"r_mm\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"transformed_parameters\"},{\"name\":\"invtausq\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"yrep\",\"type\":{\"name\":\"array\",\"length\":" << m << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik_rep\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"},{\"name\":\"sum_ll\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"sum_ll_rep\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ppp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"l_RR\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi_unsc\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << k << "},\"block\":\"parameters\"},{\"name\":\"r_mm\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"transformed_parameters\"},{\"name\":\"invtausq\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"yrep\",\"type\":{\"name\":\"array\",\"length\":" << m << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik_rep\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"},{\"name\":\"sum_ll\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"sum_ll_rep\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"ppp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"l_RR\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_CARMM_COV_P_namespace::model_CARMM_COV_P;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_CARMM_COV_P_namespace::profiles__;
}
#endif
#endif
