% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{get_predictions_lin}
\alias{get_predictions_lin}
\title{Predictions for linear regression}
\usage{
get_predictions_lin(trset,testset,outc,k)
}
\arguments{
\item{trset}{values of predictors on the training set}

\item{testset}{values of predictors on the test set}

\item{outc}{values of predictors on the training set}

\item{k}{length of the test set}
}
\value{
An array of continous variables of the length equal to the size of a \code{testset}
}
\description{
Function which runs a linear regression on a training set, computes predictions for the test set
}
\examples{
trset<-matrix(c(rnorm(90,2,4),runif(90,0,0.5),rbinom(90,1,0.5)),ncol=3)

testset<-matrix(c(rnorm(10,2,4),runif(10,0,0.5),rbinom(10,1,0.5)),ncol=3)

get_predictions_lin(trset,testset,runif(90,0,1),10)
}
\seealso{
Function uses function \code{\link[stats]{lm}} and \code{\link[stats]{coef}}
}
