% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{regr_whole}
\alias{regr_whole}
\title{Best regressions}
\usage{
regr_whole(vari, outi, crv, cutoff = NULL, part = 10, mode,
  predm = "exact", objfun = "acc", parallel = FALSE, cores,
  minx = 1, maxx = NULL, nr = NULL, maxw = NULL, st = NULL,
  rule = 10, corr = 1)
}
\arguments{
\item{vari}{set of predictors}

\item{outi}{array of outcomes}

\item{crv}{number of cross-validations}

\item{cutoff}{cut-off value for mode \code{'binary'}}

\item{part}{for each cross-validation partitions the dataset into training and test set in a proportion \code{(part-1):part}}

\item{mode}{\code{'binary'} (logistic regression), \code{'multin'} (multinomial regression)}

\item{predm}{\code{'exact'} or \code{''}; for logistic and multinomial regression; \code{'exact'} computes how many times the exact outcome category was predicted, \code{''} computes how many times either the exact outcome category or its nearest neighbour was predicted}

\item{objfun}{\code{'roc'} for maximising the predictive power with respect to AUC, available only for \code{mode='binary'}; \code{'acc'} for maximising predictive power with respect to accuracy.}

\item{parallel}{TRUE if using parallel toolbox, FALSE if not. Defaults to FALSE}

\item{cores}{number of cores to use in case of parallel=TRUE}

\item{minx}{minimum number of predictors to be included in a regression, defaults to 1}

\item{maxx}{maximum number of predictors to be included in a regression, defaults to maximum feasible number according to one in ten rule}

\item{nr}{a subset of the data-set, such that \code{1/part} of it lies in the test set and \code{1-1/part} is in the training set, defaults to empty set. This is to ensure that elements of this subset are included both in the training and in the test set.}

\item{maxw}{maximum weight of predictors to be included in a regression, defaults to maximum weight according to one in ten rule}

\item{st}{a subset of predictors to be always included into a predictive model,defaults to empty set}

\item{rule}{an Events per Variable (EPV) rule, defaults to 10}

\item{corr}{maximum correlation allowed between the variables in a single model, defaults to 1}
}
\value{
Prints the highest predictive power provided by a regression, predictive accuracy of the empirical prediction (value of \code{emp} computed by \code{cross_val} for logistic regression).
\item{ind}{Indices of the predictors included into regressions with the best predictive power written in a list. For \code{mode='linear'} a list of two lists. First list corresponds to the smallest absolute error, second corresponds to the smallest relative error. This output is identical to the one from \code{regr_ind}}
\item{regr}{List of regression objects providing the best predictions. For \code{mode='multin'} and \code{mode='binary'}}
\item{regr_a}{List of regression objects providing the best predictions with respect to absolute error.For \code{mode='linear'}}
\item{regr_r}{List of regression objects providing the best predictions with respect to relative error.For \code{mode='linear'}}
}
\description{
Function which prints the highest predictive power, predictive accuracy of the empirical prediction (value of \code{emp} computed by \code{cross_val} for logistic regression), outputs the regression objects corresponding to the highest average predictive power and the indices of the variables included into regressions with the best predictive power.
In the case of linear regression it outputs the best regressions with respect to both absolute and relative errors
}
\examples{
#creating variables for linear regression mode

variables_lin<-matrix(c(rnorm(56,0,1),rnorm(56,1,2)),ncol=2)

#creating outcomes for linear regression mode

outcomes_lin<-rnorm(56,2,1)

#running the function

regr_whole(variables_lin,outcomes_lin,20,mode='linear',parallel=TRUE,cores=2)

#creating variables for binary mode

vari<-matrix(c(1:100,seq(1,300,3)),ncol=2)

#creating outcomes for binary mode

out<-rbinom(100,1,0.3)

#running the function

regr_whole(vari,out,20,cutoff=0.5,part=10,mode='binary',parallel=TRUE,cores=2)
}
\seealso{
Uses \code{\link{regr_ind}},\code{\link[stats]{lm}}, \code{\link[nnet]{multinom}}
}
