% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{SmallBathy}
\alias{SmallBathy}
\title{Small bathymetry dataset}
\format{
raster
}
\usage{
SmallBathy()
}
\description{
Bathymetry dataset derived from the GEBCO 2024 (see \url{https://www.gebco.net/}) dataset.
Subsampled at a 10,000m resolution. Projected using the CCAMLR standard projection (\code{\link{CCAMLRp}}).
To highlight the Fishable Depth range, use \code{\link{Depth_cols2}} and \code{\link{Depth_cuts2}}.
To be only used for large scale illustrative purposes. Please refer to \code{\link{load_Bathy}}
to get higher resolution data.
}
\examples{
terra::plot(SmallBathy(),breaks=Depth_cuts,col=Depth_cols,axes=FALSE,box=FALSE)
}
\references{
GEBCO Compilation Group (2024) GEBCO 2024 Grid (doi:10.5285/1c44ce99-0a0d-5f4f-e063-7086abc0ea0f)
}
\seealso{
\code{\link{load_Bathy}}, \code{\link{add_col}}, \code{\link{add_Cscale}}, \code{\link{Depth_cols}},
\code{\link{Depth_cuts}},
\code{\link{Depth_cols2}}, \code{\link{Depth_cuts2}}, \code{\link{get_depths}}, \code{\link{create_Stations}}.
}
