% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{save_credentials}
\alias{save_credentials}
\title{Save MongoDB Credentials}
\usage{
save_credentials(
  user,
  password,
  host,
  port,
  database,
  LDAP,
  destination_path = getwd()
)
}
\arguments{
\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB server host.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{LDAP}{is LDAP being used? In this case, CEDARS will not prompt for user ID/password and a check will NOT be made on the users table. Access will be granted, relying on LDAP authentication. Annotations will be stamped with LDAP user name.}

\item{destination_path}{Folder where the files should be saved. Default is working directory.}
}
\value{
{
No return value, saves DB administrator credentials in local folder.
}
}
\description{
Saves MongoDB credentials as 'db_credentials.Rdata' and Shiny app file as 'app.R'. Those two files should be copied to the Shiny Server app directory. Needed only if using Shiny Server; credentials are entered in the command line for local app use.
}
\examples{
\dontrun{
save_credentials(user = 'John', password = 'db_password_1234', host = 'server1234',
database = 'myDB', LDAP = FALSE, destination_path = getwd())
}
}
