% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelCalculation.R
\name{kernelMatrix}
\alias{kernelMatrix}
\title{Calculate Kernel Matrix}
\usage{
kernelMatrix(X, kernFun, ...)
}
\arguments{
\item{X}{list of samples, where each list element is a suitable input for \code{kernFun}}

\item{kernFun}{Kernel function of type f(x,y)=r, where r is a scalar and x and y are elements whose similarity is evaluated.}

\item{...}{further arguments passed to distFun}
}
\value{
The similarity / kernel matrix
}
\description{
Calculate the similarities between all samples in a list, and return as matrix.
}
\examples{
x <- list(5:1,c(2,4,5,1,3),c(5,4,3,1,2), sample(5))
kernFun <- function(x,y){
		exp(-distancePermutationHamming(x,y))
}
kernelMatrix(x,distancePermutationHamming)

}
