% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFCalendarNone.R
\docType{class}
\name{CFCalendarNone}
\alias{CFCalendarNone}
\title{CF calendar with no annual cycle}
\description{
This class represents a CF calendar with no annual cycle. All
datetimes in the calendar are the same. This is useful only for repeated
experiments simulating a fixed time in the year.
}
\section{Super class}{
\code{\link[CFtime:CFCalendar]{CFtime::CFCalendar}} -> \code{CFCalendarNone}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFCalendarNone-new}{\code{CFCalendarNone$new()}}
\item \href{#method-CFCalendarNone-valid_days}{\code{CFCalendarNone$valid_days()}}
\item \href{#method-CFCalendarNone-month_days}{\code{CFCalendarNone$month_days()}}
\item \href{#method-CFCalendarNone-leap_year}{\code{CFCalendarNone$leap_year()}}
\item \href{#method-CFCalendarNone-date2offset}{\code{CFCalendarNone$date2offset()}}
\item \href{#method-CFCalendarNone-offset2date}{\code{CFCalendarNone$offset2date()}}
\item \href{#method-CFCalendarNone-clone}{\code{CFCalendarNone$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="POSIX_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-POSIX_compatible'><code>CFtime::CFCalendar$POSIX_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_compatible'><code>CFtime::CFCalendar$is_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_equivalent"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_equivalent'><code>CFtime::CFCalendar$is_equivalent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="offsets2time"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-offsets2time'><code>CFtime::CFCalendar$offsets2time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="parse"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-parse'><code>CFtime::CFCalendar$parse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="print"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-print'><code>CFtime::CFCalendar$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$new(nm, definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nm}}{The name of the calendar. This must be "none". This argument
is superfluous but maintained to be consistent with the initialization
methods of the parent and sibling classes.}

\item{\code{definition}}{The string that defines the units and the origin, as
per the CF Metadata Conventions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-valid_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-valid_days}{}}}
\subsection{Method \code{valid_days()}}{
Indicate which of the supplied dates are valid. In this
calendar only one date is valid, namely the one that the calendar is
initialized with.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$valid_days(ymd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame} with dates parsed into their parts in columns
\code{year}, \code{month} and \code{day}. Any other columns are disregarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{ymd} has rows
with \code{TRUE} for valid days and \code{FALSE} for invalid days, or \code{NA} where
the row in argument \code{ymd} has \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-month_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-month_days}{}}}
\subsection{Method \code{month_days()}}{
Determine the number of days in the month of the calendar.
This always returns a vector of \code{NA} values because this method has no
meaning for this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$month_days(ymd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame} with dates parsed into their parts in columns
\code{year}, \code{month} and \code{day}. Any other columns are disregarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector with \code{NA} values for the dates supplied as argument
\code{ymd}. If no dates are supplied, a vector of \code{NA} values of length 12.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-leap_year"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-leap_year}{}}}
\subsection{Method \code{leap_year()}}{
Indicate which years are leap years. This always returns a
vector of \code{NA} values because this method has no meaning for this
class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$leap_year(yr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yr}}{Integer vector of years to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector with the same length as argument \code{yr} with \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-date2offset"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-date2offset}{}}}
\subsection{Method \code{date2offset()}}{
Calculate difference in days between a \code{data.frame} of time
parts and the origin. The difference is always 0, given that
this is not a true calendar and there can be no calculations to
determine any difference.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$date2offset(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{data.frame}. Dates to calculate the difference for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of a length equal to the number of rows in
argument \code{x} indicating 0 for the days that equal the origin
of the calendar, or \code{NA} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-offset2date"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-offset2date}{}}}
\subsection{Method \code{offset2date()}}{
Calculate date parts from day differences from the origin.
This always returns 0's for the year, month and day as other values are
not valid in this calendar. Hour-minute-second datetime parts are
handled in \link{CFCalendar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$offset2date(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer vector of days to add to the origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} with columns 'year', 'month' and 'day' and as many
rows as the length of vector \code{x}. Rows with values of \code{x} other than 0
will return the values for the origin of the calendar nonetheless, in
accordance with the CF Metadata Conventions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarNone-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarNone-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarNone$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
