\name{getPara}
\alias{getPara}
\title{
Initialize parameters for AGP estimation
}
\description{
This function sets default values to parameters required to run AGP estimation.
}
\usage{
getPara()
}
\value{
The default parameters obtained from this function is essential to run \code{getAGP()}. These parameters include:
\item{datafile}{full path to input data file generated by \code{getSeg()} or in the same format}
\item{savefile}{name of the output plain text file to be saved}
\item{pngdir}{directory to save BAF-LRR plots, ignored if is.png is FALSE}
\item{BAFfilter}{DNA segments with BAF markers below this value are removed to reduce noise. Default 10}
\item{thr.kmeans}{convergence threshold for \code{getKmeans()}. Default 0.1}
\item{thr.originsize}{minimum number of markers included in the origin cluster, used by \code{getOrigin()}. Default 500}
\item{thr.CL}{threshold distance to call a data point to be close to a canonical line, used by \code{getSumDist()}. Default 0.05}
\item{thr.CP}{threshold distance to call a data point to be close to a canonical point, used by \code{getSumDist()}. Default 0.05}
\item{thr.penalty}{penalty (in units of number of markers) to increase ploidy. Default 500}
\item{std.BAF}{standard deviation of BAF markers. Default 0.02}
\item{std.LRR}{standard deviation of LRR markers. Default 0.08}
\item{exclude.chr}{chromosomes to be excluded from the analysis. Default NULL}
\item{res.r}{resampling ratio for bootstrap. Default 0.8}
\item{num.tracks}{number of canonical tracks to be considered in likelihood estimation. Default 4}
\item{is.normalize}{if data needs to be normalized first. Default TRUE}
\item{is.perm}{if bootstrap based null distribution of AGP is estimated, time consuming. Default FALSE}
\item{is.png}{if BAF-LRR plots are saved. Default TRUE}
\item{is.plot}{if BAF-LRR plots are shown during the process of AGP estimation. Default TRUE}
\item{LRR_correction_del}{factor to correct negative LRR values. Default 0.572}
\item{LRR_correction_amp}{factor to correct positive LRR values. Default 0.553}
}
\author{
Bo Li
}
\examples{
para=getPara()
## Change threshold for ploidy increase
para$thr.penalty=200
## Skip png plotting
para$is.png=FALSE
}