% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_fun.R
\name{att_fun}
\alias{att_fun}
\title{OR/RR/RD estimation for ATT}
\usage{
att_fun(wt12, wt13, y, trt_ind)
}
\arguments{
\item{wt12}{weight for treatment group 2 in ATT}

\item{wt13}{weight for treatment group 3 in ATT}

\item{y}{numeric vector for the binary outcome}

\item{trt_ind}{numeric vector for the treatment indicator}
}
\value{
list with 2 elements for ATT effect. It contains
\item{ATT12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATT13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
The function estimates OR/RR/RD for ATT. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
att_fun(wt12 = 1:100, wt13 = 1:100, y  =1:100, trt_ind =  rep(1:3, c(32,32,36)))
}
