% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iptw_multiTrt.R
\name{iptw_multiTrt}
\alias{iptw_multiTrt}
\title{Inverse probability of treatment weighting (IPTW)}
\usage{
iptw_multiTrt(y, trt, psdat, estimand = "ATE", method, wt1, wt2, wt3,
  wt12, wt13, trim_alpha, SL.library)
}
\arguments{
\item{y}{numeric vector for the binary outcome}

\item{trt}{numeric vector for the treatment indicator}

\item{psdat}{data frame containing the treatment indicator and covariates}

\item{estimand}{causal estimands, "ATT" or "ATE"}

\item{method}{methods for causal inference with multiple treatments, inherited from causal_multi_treat.R}

\item{wt1}{weight for treatment group 1 in ATE}

\item{wt2}{weight for treatment group 2 in ATE}

\item{wt3}{weight for treatment group 3 in ATE}

\item{wt12}{weight for treatment group 2 in ATT}

\item{wt13}{weight for treatment group 3 in ATT}

\item{trim_alpha}{alpha values for IPTW weight trimming, inherited from causal_multi_treat.R}

\item{SL.library}{methods specified with SL.library in Superlearner package, inherited from causal_multi_treat.R}
}
\value{
list with 2 elements for ATT effect. It contains
\item{ATT12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATT13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
list with 3 elements for ATE effect. It contains
\item{ATE12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE23:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
This function implements the IPTW method. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
set.seed(1)
idata = data_gen(n = 50, ratio =1,scenario = 1)
trt_ind <- as.numeric(idata$trtdat$trt_ind)
all_vars <- idata$trtdat[, -1] #exclude treatment indicator
y <- idata$Yobs
iptw_multiTrt(y=y, trt = trt_ind,SL.library = c("SL.glm"),
trim_alpha = 0.05, method = "IPTW-GBM", estimand = "ATT")
}
