\name{as.character.docinfo}
\alias{as.character.docinfo}
\title{Coerce a docinfo object to character string}
\usage{as.character.docinfo(x, ...)}
\description{Converts an object of type \code{docinfo} to a character string.
Such an object is  returned by e.g. \code{\link{lbsGetInfoDocuments}}.}
\details{A \code{docinfo} object is a list with the following components:
\itemize{
\item \code{IdDocument} --- numeric; document identifier in the table \code{Biblio_Documents},
\item \code{Authors} --- list of \code{authorinfo} objects (see e.g. \code{\link{as.character.authorinfo}}).
\item \code{Title} --- title of the document,
\item \code{BibEntry} --- bibliographic entry,
\item \code{UniqueId} --- unique character identifier,
\item \code{Pages} --- number of pages,
\item \code{Citations} --- number of citations,
\item \code{Year} --- publication year,
\item \code{Type} --- type of document, see \code{\link{lbsCreate}}.
}}
\value{A character string}
\seealso{\code{\link{lbsSearchDocuments}},
\code{\link{as.character.authorinfo}}, \code{\link{print.docinfo}},\cr
\code{\link{lbsGetInfoDocuments}}}
\arguments{\item{x}{a single object of type \code{docinfo}.}
\item{...}{unused.}}
