% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.r
\name{confint.clme}
\alias{confint.clme}
\alias{confint.summary.clme}
\title{Individual confidence intervals}
\usage{
\method{confint}{clme}(object, parm, level = 0.95, ...)

\method{confint}{summary.clme}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{parm}{parameter for which confidence intervals are computed (not used).}

\item{level}{nominal confidence level.}

\item{...}{space for additional arguments.}
}
\value{
Returns a matrix with two columns named lcl and ucl (lower and upper confidence limit).
}
\description{
Calculates confidence intervals for fixed effects parameter estimates in objects of class \code{clme}.

Calculates confidence intervals for fixed effects parameter estimates in objects of class \code{clme}.
}
\details{
Confidence intervals are computed using Standard Normal critical values.
Standard errors are taken from the covariance matrix of the unconstrained parameter estimates.
}
\examples{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood ,
                 constraints = cons, seed = 42, nsim = 0)

confint( clme.out )
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}

\code{\link{CLME-package}}
\code{\link{clme}}
}

