% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_clme.r
\name{print.summary.clme}
\alias{print.summary.clme}
\title{S3 method to print a summary for objects of class \code{clme}}
\usage{
\method{print}{summary.clme}(x, alpha = 0.05, digits = 4, ...)
}
\arguments{
\item{x}{an object of class \code{clme}.}

\item{alpha}{level of significance.}

\item{digits}{number of decimal digits to print.}

\item{...}{additional arguments passed to other functions.}
}
\value{
\code{NULL}, just prints results to the console.
}
\description{
Summarizes the output of objects of class \code{clme}, such as those produced by \code{\link{clme}}. Prints a tabulated display of global and individual tests, as well as parameter estimates.
}
\note{
The individual tests are performed on the specified order. If no specific order was specified, then the individual tests are performed on the estimated order.
}
\examples{
\dontrun{
  set.seed( 42 )
  data( rat.blood )
  cons <- list(order = "simple", decreasing = FALSE, node = 1 )
  clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                   constraints = cons, seed = 42, nsim = 10)
  
  summary( clme.out )
}

}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}

