% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_switchgear_30_60kv.R
\name{pof_future_switchgear_30_60kv}
\alias{pof_future_switchgear_30_60kv}
\title{Future Probability of Failure for 30kV and 60kV Switchgear}
\usage{
pof_future_switchgear_30_60kv(
  asset_type = "30kV",
  placement = "Default",
  number_of_operations = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  measured_condition_inputs,
  observed_condition_inputs,
  reliability_factor = "Default",
  k_value = "Default",
  c_value = 1.087,
  normal_expected_life = 55,
  simulation_end_year = 100
)
}
\arguments{
\item{asset_type}{String Asset Type}

\item{placement}{String Placement}

\item{number_of_operations}{String Number of Operations}

\item{altitude_m}{String Altitude}

\item{distance_from_coast_km}{String Distance from coast}

\item{corrosion_category_index}{String Corrosion Category Index}

\item{age}{Numeric Age}

\item{measured_condition_inputs}{Named list observed_conditions_input}

\item{observed_condition_inputs}{Named list observed_conditions_input}

\item{reliability_factor}{String Reliability Factor}

\item{k_value}{Numeric. \code{k_value = 0.0077} by default. This number is
given in a percentage. The default value is accordingly to the standard
"DE-10kV apb kabler CNAIM" on p. 34.}

\item{c_value}{Numeric. \code{c_value = 1.087} by default.
The default value is accordingly to the CNAIM standard see page 110}

\item{normal_expected_life}{Numeric. \code{normal_expected_life = 55} by default.
The default value is accordingly to the standard
"DE-10kV apb kabler CNAIM" on p. 33.}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric. Current probability of failure
per annum.
}
\description{
This function calculates the future
annual probability of failure 30kV and 60kV switchgear.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function.
}
\examples{
# Future annual probability of failure for 30kV and 60kV Swicthgear
}
