% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{applyBliss}
\alias{applyBliss}
\title{Function calculates of Bliss Synergy, associated BIs and global BIs}
\usage{
applyBliss(noOfRows, noOfCols, rawDataPreProcessed, nBoot)
}
\arguments{
\item{noOfRows}{Number of rows in the experiment}

\item{noOfCols}{Number of columns in the experiment}

\item{rawDataPreProcessed}{Data matrix}

\item{nBoot}{Number of bootstrap}
}
\value{
Three lists, first list consists of Bliss Synergy/Antagonism, lower bound of BI and 
upper bound of BI. 2nd list consists of global BI of Maximun synergistic combiantion and 3rd list 
consists of global BI of maximum antagonistic combination.
}
\description{
Function calculates of Bliss Synergy, associated BIs and global BIs
}
\examples{
dataFile <- system.file( "extdata", "rawDataPreProcessed.csv", package="COMBIA" )
dataSample <- read.csv(dataFile, header=FALSE )
nR <- 8
nC <- 10
rslt <- applyBliss(nR, nC,  as.matrix(dataSample ), 500) 
}
\author{
Muhammad kashif
}
