% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cre.R
\name{cre}
\alias{cre}
\title{Causal rule ensemble}
\usage{
cre(y, z, X, method_params = NULL, hyper_params = NULL, ite = NULL)
}
\arguments{
\item{y}{An observed response vector.}

\item{z}{A treatment vector.}

\item{X}{A covariate matrix (or a data frame). Should be provided as
numerical values.}

\item{method_params}{The list of parameters to define the models used,
including:
\itemize{
\item \emph{Parameters for Honest Splitting}
\itemize{
\item \emph{ratio_dis}: The ratio of data delegated to rules discovery
(default: 0.5).
}
\item \emph{Parameters for Discovery and Inference}
\itemize{
\item \emph{ite_method}: The method for ITE (pseudo-outcome) estimation
(default: \code{"aipw"}, options: \code{"aipw"} for Augmented Inverse
Probability Weighting, \code{"cf"} for Causal Forest, \code{"bart"} for
Causal Bayesian Additive Regression Trees, \code{"slearner"} for S-Learner,
\code{"tlearner"} for T-Learner, \code{"xlearner"} for X-Learner,
\code{"tpoisson"} for T-Learner with Poisson regression).
\item \emph{learner_ps}: The model for the propensity score estimation
(default: \code{"SL.xgboost"}, options: any SuperLearner prediction model
i.e., \code{"SL.lm"}, \code{"SL.svm"}, used only for \code{"aipw"},
\code{"bart"}, \code{"cf"} ITE estimators).
\item \emph{learner_y}: The model for the outcome estimation
(default: \code{"SL.xgboost"}, options: any SuperLearner prediction model
i.e., \code{"SL.lm"}, \code{"SL.svm"}, used only for \code{"aipw"},
\code{"slearner"}, \code{"tlearner"} and \code{"xlearner"} ITE
estimators).
}
}}

\item{hyper_params}{The list of hyper parameters to fine-tune the method,
including:
\itemize{
\item \emph{General hyper parameters}
\itemize{
\item \emph{intervention_vars}: Array with intervention-able covariates names used
for Rules Generation. Empty or null array means that all the covariates
are considered as intervention-able (default: \code{NULL}).
\item \emph{ntrees}: The number of decision trees for random forest (default: 20).
\item \emph{node_size}: Minimum size of the trees' terminal nodes (default: 20).
\item \emph{max_rules}: Maximum number of generated candidates rules (default: 50).
\item \emph{max_depth}: Maximum rules length (default: 3).
\item \emph{t_decay}: The decay threshold for rules pruning. Higher values will
carry out an aggressive pruning (default: 0.025).
\item \emph{t_ext}: The threshold to truncate too generic or too specific (extreme)
rules (default: 0.01, range: [0, 0.5)).
\item \emph{t_corr}: The threshold to define correlated rules (default: 1,
range: \verb{[0,+inf)}).
\item \emph{stability_selection}: Method for stability selection for selecting the
rules. \code{"vanilla"} for stability selection, \code{"error_control"}
for stability selection with error control and  \code{"no"} for no
stability selection (default: \code{"vanilla"}).
\item \emph{B}: Number of bootstrap samples for stability selection in rules
selection and uncertainty quantification in estimation (default: 20).
\item \emph{subsample}: Bootstrap ratio subsample for stability selection in rules
selection and uncertainty quantification in estimation (default: 0.5).
}
\item \emph{Method specific hyper parameters}
\itemize{
\item \emph{offset}: Name of the covariate to use as offset (i.e., \code{"x1"}) for
T-Poisson ITE estimation. Use \code{NULL} if offset is not used (default:
\code{NULL}).
\item \emph{cutoff}:  Threshold (percentage) defining the minimum cutoff value for
the stability scores for Stability Selection (default: 0.9).
\item \emph{pfer}: Upper bound for the per-family error rate (tolerated amount of
falsely selected rules) for Error Control Stability Selection (default: 1).
}
}}

\item{ite}{The estimated ITE vector. If given both the ITE estimation steps
in Discovery and Inference are skipped (default: \code{NULL}).}
}
\value{
An S3 object composed by:
\item{M}{the number of Decision Rules extracted at each step,}
\item{CATE}{the data.frame of Conditional Average Treatment Effect
decomposition estimates with corresponding uncertainty quantification,}
\item{method_params}{the list of method parameters,}
\item{hyper_params}{the list of hyper parameters,}
\item{rules}{the list of rules (implicit form) decomposing the CATE.}
}
\description{
Performs the Causal Rule Ensemble on a data set with a response variable,
a treatment variable, and various features.
}
\note{
\itemize{
\item If \code{intervention_vars} are provided, it is important to note that the
individual treatment effect will still be computed using all covariates.
}
}
\examples{

\donttest{
set.seed(123)
dataset <- generate_cre_dataset(n = 400,
                                rho = 0,
                                n_rules = 2,
                                p = 10,
                                effect_size = 2,
                                binary_covariates = TRUE,
                                binary_outcome = FALSE,
                                confounding = "no")
y <- dataset[["y"]]
z <- dataset[["z"]]
X <- dataset[["X"]]

method_params <- list(ratio_dis = 0.5,
                      ite_method ="aipw",
                      learner_ps = "SL.xgboost",
                      learner_y = "SL.xgboost")

hyper_params <- list(intervention_vars = NULL,
                     offset = NULL,
                     ntrees = 20,
                     node_size = 20,
                     max_rules = 50,
                     max_depth = 3,
                     t_decay = 0.025,
                     t_ext = 0.025,
                     t_corr = 1,
                     stability_selection = "vanilla",
                     cutoff = 0.6,
                     pfer = 1,
                     B = 20,
                     subsample = 0.5)

cre_results <- cre(y, z, X, method_params, hyper_params)
}

}
