% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{randomizeCRT}
\alias{randomizeCRT}
\title{Randomize a two-armed cluster randomized trial}
\usage{
randomizeCRT(
  trial,
  matchedPair = FALSE,
  baselineNumerator = "base_num",
  baselineDenominator = "base_denom"
)
}
\arguments{
\item{trial}{an object of class \code{"CRTsp"} or a data frame containing locations in (x,y) coordinates, cluster
assignments (factor \code{cluster}), and arm assignments (factor \code{arm}). Optionally: specification of a buffer zone (logical \code{buffer});
any other variables required for subsequent analysis.}

\item{matchedPair}{logical: indicator of whether pair-matching on the
baseline data should be used in randomization}

\item{baselineNumerator}{name of numerator variable for baseline data (required for
matched-pair randomization)}

\item{baselineDenominator}{name of denominator variable for baseline data (required for
matched-pair randomization)}
}
\value{
A list of class \code{"CRTsp"} containing the following components:
\tabular{lll}{
\code{design}   \tab list: \tab parameters required for power calculations\cr
\code{geom_full}   \tab list: \tab summary statistics describing the site \cr
\code{geom_core}   \tab list: \tab summary statistics describing the core area
(when a buffer is specified)\cr
\code{trial} \tab data frame: \tab rows correspond to geolocated points, as follows:\cr
\tab \code{x} \tab numeric vector: x-coordinates of locations \cr
\tab \code{y} \tab numeric vector: y-coordinates of locations \cr
\tab \code{cluster} \tab factor: assignments to cluster of each location  \cr
\tab \code{pair} \tab factor: assigned matched pair of each location
(for \code{matchedPair} randomisations) \cr
\tab \code{arm} \tab factor: assignments to \code{"control"} or \code{"intervention"} for each location \cr
\tab \code{...} \tab other objects included in the input \code{"CRTsp"} object or data frame \cr
}
}
\description{
\code{randomizeCRT} carries out randomization of clusters for a CRT and
augments the trial dataframe with assignments to arms \cr
}
\examples{
# Randomize the clusters in an example trial
exampleCRT <- randomizeCRT(trial = readdata('exampleCRT.txt'), matchedPair = TRUE)
}
