% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_wbt_filenames.R
\name{ch_wbt_filenames}
\alias{ch_wbt_filenames}
\title{Creates names for Whitebox function input and output files}
\usage{
ch_wbt_filenames(
  wd = NULL,
  fn_dem = "dem.tif",
  fn_dem_fsc = "dem_fsc.tif",
  fn_dem_ns = "dem_ns.tif",
  fn_flowacc = "flow_acc.tif",
  fn_flowdir = "flow_dir.tif",
  fn_channel_ras = "channel.tif",
  fn_channel_vec = "channel.shp",
  fn_catchment_ras = "catchment.tif",
  fn_catchment_vec = "catchment.shp",
  fn_pp = "pp.shp",
  fn_pp_snap = "pp_snap.shp"
)
}
\arguments{
\item{wd}{Required. Name of working directory.}

\item{fn_dem}{File name of input DEM. Default is \option{dem.tif}.}

\item{fn_dem_fsc}{File name for dem after filling single-cell pits. Default is \option{dem_fsc.tif}.}

\item{fn_dem_ns}{File name for dem removing sinks. Default is \option{dem_ns.tif}.}

\item{fn_flowacc}{File name for DEM flow accumulation grid Default is \option{flow_acc.tif}.}

\item{fn_flowdir}{File name for DEM flow direction grid. Default is \option{flow_dir.tif}.}

\item{fn_channel_ras}{File name for raster version of channel network. Default is \option{channel.tif}.}

\item{fn_channel_vec}{File name for vector version of channel networks. Default is \option{channel.shp}.}

\item{fn_catchment_ras}{File name for raster version of catchment. Default is \option{catchment.tif}.}

\item{fn_catchment_vec}{File name for vector version of catchment. Default is \option{catchment.shp}.}

\item{fn_pp}{File name for pour points (input). Vector file. Default is \option{pp.shp}.}

\item{fn_pp_snap}{File name for pour points after snapping to channel network. Vector file. Default is \option{pp.shp}.}
}
\value{
Returns a list of the input and output file names
}
\description{
Creates a list of the files used for inputs and outputs by the
Whitebox functions. This function needs to be called before calling any of the other
Whitebox (i.e. those prefixed by \code{cd_wbt}) functions. If the file names are not specified, default names will 
be used. All raster files are TIFF (.tif), all vector files are shapefiles (.shp).
}
\examples{
wbt_file_names <- ch_wbt_filenames(getwd())

}
\author{
Dan Moore
}
