% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MultiEOF.R
\name{CST_MultiEOF}
\alias{CST_MultiEOF}
\title{EOF analysis of multiple variables}
\usage{
CST_MultiEOF(
  datalist,
  neof_max = 40,
  neof_composed = 5,
  minvar = 0.6,
  lon_lim = NULL,
  lat_lim = NULL
)
}
\arguments{
\item{datalist}{A list of objects of the class 's2dv_cube', containing the 
variables to be analysed. Each data object in the list is expected to have 
an element named \code{$data} with at least two spatial dimensions named 
"lon" and "lat", a dimension "ftime" and a dimension "sdate". Latitudinal 
dimension accepted names: 'lat', 'lats', 'latitude', 'y', 'j', 'nav_lat'. 
Longitudinal dimension accepted names: 'lon', 'lons','longitude', 'x', 'i', 
'nav_lon'.}

\item{neof_max}{Maximum number of single eofs considered in the first 
decomposition.}

\item{neof_composed}{Number of composed eofs to return in output.}

\item{minvar}{Minimum variance fraction to be explained in first decomposition.}

\item{lon_lim}{Vector with longitudinal range limits for the EOF calculation 
for all input variables.}

\item{lat_lim}{Vector with latitudinal range limits for the EOF calculation 
for all input variables.}
}
\value{
A list with elements \code{$coeff} (an array of time-varying principal 
component coefficients), \code{$variance} (a matrix of explained variances),
\code{eof_pattern} (a matrix of EOF patterns obtained by regression for each 
variable).
}
\description{
This function performs EOF analysis over multiple variables,
accepting in input a list of CSTools objects. Based on Singular Value 
Decomposition. For each field the EOFs are computed and the corresponding PCs 
are standardized (unit variance, zero mean); the minimum number of principal 
components needed to reach the user-defined variance is retained. The function 
weights the input data for the latitude cosine square root.
}
\examples{
seq <- 1 : (2 * 3 * 4 * 5 * 6 * 8)
mod1 <- sin( 0.7 + seq )^2 + cos( seq ^ 2 * 1.22  )
dim(mod1) <- c(dataset = 2, member = 3, sdate = 4, ftime = 5, lat = 6, 
              lon = 8)
mod2 <- sin( seq * 2 ) ^ 3 + cos( seq ^ 2 )
dim(mod2) <- c(dataset = 2, member = 3, sdate = 4, ftime = 5, lat = 6, 
              lon = 8)
lon <- seq(0, 35, 5)
lat <- seq(0, 25, 5)
exp1 <- list(data = mod1, coords = list(lat = lat, lon = lon))
exp2 <- list(data = mod2, coords = list(lat = lat, lon = lon))
attr(exp1, 'class') <- 's2dv_cube'
attr(exp2, 'class') <- 's2dv_cube'
d = as.POSIXct(c("2017/01/01", "2017/01/02", "2017/01/03", "2017/01/04", 
                "2017/01/05", "2018/01/01", "2018/01/02", "2018/01/03",
                "2018/01/04", "2018/01/05", "2019/01/01", "2019/01/02", 
                "2019/01/03", "2019/01/04", "2019/01/05", "2020/01/01", 
                "2020/01/02", "2020/01/03", "2020/01/04", "2020/01/05"))
exp1$attrs$Dates = d
exp2$attrs$Dates = d

cal <- CST_MultiEOF(datalist = list(exp1, exp2), neof_composed = 2)
}
\author{
Jost von Hardenberg - ISAC-CNR, \email{j.vonhardenberg@isac.cnr.it}

Paolo Davini - ISAC-CNR, \email{p.davini@isac.cnr.it}
}
