% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{thin}
\alias{thin}
\title{Apply a higher threshold to a CTRE process}
\usage{
thin(ctre, k)
}
\arguments{
\item{ctre}{A \code{\link{ctre}} object.}

\item{k}{Discard all but the \code{k} largest magnitudes.}
}
\value{
A \code{\link{ctre}} object, with fewer (k) observations.
}
\description{
Drop all but the \code{k} largest observations.
}
\examples{
  library(magrittr)
  flares \%>\% ctre() \%>\% plot(log = 'y')
  flares \%>\% ctre() \%>\% thin(k=500) \%>\% plot(log = 'y')
}
