% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{BoolConstr-class}
\alias{BoolConstr-class}
\alias{.BoolConstr}
\alias{BoolConstr}
\alias{BoolConstr}
\alias{format_constr,BoolConstr-method}
\alias{size,BoolConstr-method}
\title{The BoolConstr class.}
\usage{
BoolConstr(lin_op)

\S4method{format_constr}{BoolConstr}(object, eq_constr, leq_constr, dims,
  solver)

\S4method{size}{BoolConstr}(object)
}
\arguments{
\item{lin_op}{A list representing the linear operator equal to the \code{.noncvx_var}.}

\item{object}{A \linkS4class{BoolConstr} object.}

\item{eq_constr}{A list of the equality constraints in the canonical problem.}

\item{leq_constr}{A list of the inequality constraints in the canonical problem.}

\item{dims}{A list with the dimensions of the conic constraints.}

\item{solver}{A string representing the solver to be called.}
}
\description{
This class represents a boolean constraint, \eqn{X_{ij} \in \{0,1\}} for all \eqn{i,j}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{format_constr}: Format SDP constraints as inequalities for the solver.

\item \code{size}: The dimensions of the semidefinite cone.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{lin_op}}{A list representing the linear operator equal to the \code{.noncvx_var}.}

\item{\code{.noncvx_var}}{(Internal) A list representing the variable constrained to be elementwise boolean.}
}}

