% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\docType{class}
\name{ECOS-class}
\alias{ECOS-class}
\alias{ECOS}
\alias{lp_capable,ECOS-method}
\alias{socp_capable,ECOS-method}
\alias{sdp_capable,ECOS-method}
\alias{exp_capable,ECOS-method}
\alias{mip_capable,ECOS-method}
\alias{name,ECOS-method}
\alias{import_solver,ECOS-method}
\alias{Solver.solve,ECOS-method}
\alias{format_results,ECOS-method}
\title{The ECOS class.}
\usage{
ECOS()

\S4method{lp_capable}{ECOS}(solver)

\S4method{socp_capable}{ECOS}(solver)

\S4method{sdp_capable}{ECOS}(solver)

\S4method{exp_capable}{ECOS}(solver)

\S4method{mip_capable}{ECOS}(solver)

\S4method{name}{ECOS}(object)

\S4method{import_solver}{ECOS}(solver)

\S4method{Solver.solve}{ECOS}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)

\S4method{format_results}{ECOS}(solver, results_dict, data, cached_data)
}
\arguments{
\item{object, solver}{An \linkS4class{ECOS} object.}

\item{objective}{A list representing the canonicalized objective.}

\item{constraints}{A list of canonicalized constraints.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}

\item{results_dict}{A list containing the solver output.}

\item{data}{A list containing information about the problem.}
}
\description{
This class is an interface for the ECOS solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{lp_capable}: ECOS can handle linear programs.

\item \code{socp_capable}: ECOS can handle second-order cone programs.

\item \code{sdp_capable}: ECOS cannot handle semidefinite programs.

\item \code{exp_capable}: ECOS can handle exponential cone programs.

\item \code{mip_capable}: ECOS cannot handle mixed-integer programs.

\item \code{name}: The name of the solver.

\item \code{import_solver}: Imports the ECOSolveR library.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.

\item \code{format_results}: Convert raw solver output into standard list of results.
}}

\examples{
ecos <- ECOS()
lp_capable(ecos)
sdp_capable(ecos)
socp_capable(ecos)
exp_capable(ecos)
mip_capable(ecos)
}
\references{
A. Domahidi, E. Chu, and S. Boyd. "ECOS: An SOCP solver for Embedded Systems." \emph{Proceedings of the European Control Conference}, pp. 3071-3076, 2013.
}
\seealso{
\code{\link[ECOSolveR]{ECOS_csolve}} and the \href{https://www.embotech.com/ECOS}{ECOS Official Site}.
}
