% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/constraints.R
\docType{methods}
\name{<=,Expression,Expression-method}
\alias{<=,Expression,Expression-method}
\alias{<=,Expression,ConstVal-method}
\alias{<=,ConstVal,Expression-method}
\alias{<,Expression,Expression-method}
\alias{<,Expression,ConstVal-method}
\alias{<,ConstVal,Expression-method}
\alias{>=,Expression,Expression-method}
\alias{>=,Expression,ConstVal-method}
\alias{>=,ConstVal,Expression-method}
\alias{>,Expression,Expression-method}
\alias{>,Expression,ConstVal-method}
\alias{>,ConstVal,Expression-method}
\alias{LeqConstraint-class}
\alias{.LeqConstraint}
\alias{LeqConstraint}
\alias{as.character,LeqConstraint-method}
\alias{id,LeqConstraint-method}
\alias{size,LeqConstraint-method}
\alias{is_dcp,LeqConstraint-method}
\alias{canonicalize,LeqConstraint-method}
\alias{variables,LeqConstraint-method}
\alias{parameters,LeqConstraint-method}
\alias{constants,LeqConstraint-method}
\alias{residual,LeqConstraint-method}
\alias{value,LeqConstraint-method}
\alias{violation,LeqConstraint-method}
\title{The LeqConstraint class.}
\usage{
\S4method{<=}{Expression,Expression}(e1, e2)

\S4method{<=}{Expression,ConstVal}(e1, e2)

\S4method{<=}{ConstVal,Expression}(e1, e2)

\S4method{<}{Expression,Expression}(e1, e2)

\S4method{<}{Expression,ConstVal}(e1, e2)

\S4method{<}{ConstVal,Expression}(e1, e2)

\S4method{>=}{Expression,Expression}(e1, e2)

\S4method{>=}{Expression,ConstVal}(e1, e2)

\S4method{>=}{ConstVal,Expression}(e1, e2)

\S4method{>}{Expression,Expression}(e1, e2)

\S4method{>}{Expression,ConstVal}(e1, e2)

\S4method{>}{ConstVal,Expression}(e1, e2)

LeqConstraint(lh_exp, rh_exp)

\S4method{as.character}{LeqConstraint}(x)

\S4method{id}{LeqConstraint}(object)

\S4method{size}{LeqConstraint}(object)

\S4method{is_dcp}{LeqConstraint}(object)

\S4method{canonicalize}{LeqConstraint}(object)

\S4method{variables}{LeqConstraint}(object)

\S4method{parameters}{LeqConstraint}(object)

\S4method{constants}{LeqConstraint}(object)

\S4method{residual}{LeqConstraint}(object)

\S4method{value}{LeqConstraint}(object)

\S4method{violation}{LeqConstraint}(object)
}
\arguments{
\item{e1, e2}{The \linkS4class{Expression} objects or numeric constants to compare.}

\item{lh_exp}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the left-hand side of the inequality.}

\item{rh_exp}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the right-hand side of the inequality.}

\item{x, object}{A \linkS4class{LeqConstraint} object.}
}
\description{
This class represents a \eqn{\leq} inequality constraint.
}
\section{Methods (by generic)}{
\itemize{
\item \code{id}: The \code{constr_id} of the constraint.

\item \code{size}: The size of the left-hand expression minus the right-hand expression.

\item \code{is_dcp}: The constraint is DCP if the left-hand expression is convex and the right-hand expression is concave.

\item \code{canonicalize}: The graph implementation of the object. Marks the top level constraint as the \code{dual_holder} so the dual value will be saved to the \linkS4class{LeqConstraint}.

\item \code{variables}: List of \linkS4class{Variable} objects in the constraint.

\item \code{parameters}: List of \linkS4class{Parameter} objects in the constraint.

\item \code{constants}: List of \linkS4class{Constant} objects in the constraint.

\item \code{residual}: The elementwise maximum of the left-hand expression minus the right-hand expression, i.e. \code{max_elemwise(lh_exp - rh_exp, 0)}.

\item \code{value}: A logical value indicating whether the constraint holds. Tolerance is currently set at \code{1e-4}.

\item \code{violation}: A matrix representing the amount by which the constraint is off, i.e. the numeric value of the residual expression.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{lh_exp}}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the left-hand side of the inequality.}

\item{\code{rh_exp}}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the right-hand side of the inequality.}

\item{\code{args}}{(Internal) A list that holds \code{lh_exp} and \code{rh_exp} for internal use.}

\item{\code{.expr}}{(Internal) An \linkS4class{Expression} representing \code{lh_exp - rh_exp} for internal use.}

\item{\code{dual_variable}}{(Internal) A \linkS4class{Variable} representing the dual variable associated with the constraint.}
}}

