% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{matrix_frac}
\alias{matrix_frac}
\title{Matrix Fraction}
\usage{
matrix_frac(X, P)
}
\arguments{
\item{X}{An \linkS4class{Expression} or matrix. Must have the same number of rows as \code{P}.}

\item{P}{An \linkS4class{Expression} or matrix. Must be an invertible square matrix.}
}
\value{
An \linkS4class{Expression} representing the matrix fraction evaluated at the input.
}
\description{
\eqn{tr(X^T P^{-1} X)}.
}
\examples{
\dontrun{
m <- 100
n <- 80
r <- 70

A <- matrix(stats::rnorm(m*n), nrow = m, ncol = n)
b <- matrix(stats::rnorm(m), nrow = m, ncol = 1)
G <- matrix(stats::rnorm(r*n), nrow = r, ncol = n)
h <- matrix(stats::rnorm(r), nrow = r, ncol = 1)

# ||Ax-b||^2 = x^T (A^T A) x - 2(A^T b)^T x + ||b||^2
P <- t(A) \%*\% A
q <- -2 * t(A) \%*\% b
r <- t(b) \%*\% b
Pinv <- base::solve(P)

x <- Variable(n)
obj <- matrix_frac(x, Pinv) + t(q) \%*\% x + r
constr <- list(G \%*\% x == h)
prob <- Problem(Minimize(obj), constr)
result <- solve(prob)
result$value
}
}
