% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{LogDet-class}
\alias{LogDet-class}
\alias{.LogDet}
\alias{LogDet}
\alias{to_numeric,LogDet-method}
\alias{validate_args,LogDet-method}
\alias{dim_from_args,LogDet-method}
\alias{sign_from_args,LogDet-method}
\alias{is_atom_convex,LogDet-method}
\alias{is_atom_concave,LogDet-method}
\alias{is_incr,LogDet-method}
\alias{is_decr,LogDet-method}
\alias{.grad,LogDet-method}
\alias{.domain,LogDet-method}
\title{The LogDet class.}
\usage{
LogDet(A)

\S4method{to_numeric}{LogDet}(object, values)

\S4method{validate_args}{LogDet}(object)

\S4method{dim_from_args}{LogDet}(object)

\S4method{sign_from_args}{LogDet}(object)

\S4method{is_atom_convex}{LogDet}(object)

\S4method{is_atom_concave}{LogDet}(object)

\S4method{is_incr}{LogDet}(object, idx)

\S4method{is_decr}{LogDet}(object, idx)

\S4method{.grad}{LogDet}(object, values)

\S4method{.domain}{LogDet}(object)
}
\arguments{
\item{A}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{LogDet} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
The natural logarithm of the determinant of a matrix, \eqn{\log\det(A)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(LogDet)}: The log-determinant of SDP matrix \code{A}. This is the sum of logs of the eigenvalues and is equivalent to the nuclear norm of the matrix logarithm of \code{A}.

\item \code{validate_args(LogDet)}: Check that \code{A} is square.

\item \code{dim_from_args(LogDet)}: The atom is a scalar.

\item \code{sign_from_args(LogDet)}: The atom is non-negative.

\item \code{is_atom_convex(LogDet)}: The atom is not convex.

\item \code{is_atom_concave(LogDet)}: The atom is concave.

\item \code{is_incr(LogDet)}: The atom is not monotonic in any argument.

\item \code{is_decr(LogDet)}: The atom is not monotonic in any argument.

\item \code{.grad(LogDet)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.domain(LogDet)}: Returns constraints describing the domain of the node

}}
\section{Slots}{

\describe{
\item{\code{A}}{An \linkS4class{Expression} or numeric matrix.}
}}

