% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solvers.R
\docType{class}
\name{CPLEX_QP-class}
\alias{CPLEX_QP-class}
\alias{CPLEX_QP}
\alias{mip_capable,CPLEX_QP-method}
\alias{status_map,CPLEX_QP-method}
\alias{name,CPLEX_QP-method}
\alias{import_solver,CPLEX_QP-method}
\alias{invert,CPLEX_QP,list,InverseData-method}
\alias{solve_via_data,CPLEX_QP-method}
\title{An interface for the CPLEX solver.}
\usage{
CPLEX_QP()

\S4method{mip_capable}{CPLEX_QP}(solver)

\S4method{status_map}{CPLEX_QP}(solver, status)

\S4method{name}{CPLEX_QP}(x)

\S4method{import_solver}{CPLEX_QP}(solver)

\S4method{invert}{CPLEX_QP,list,InverseData}(object, solution, inverse_data)

\S4method{solve_via_data}{CPLEX_QP}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{status}{A status code returned by the solver.}

\item{x, object, solver}{A \linkS4class{CPLEX_QP} object.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A \linkS4class{InverseData} object containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the CPLEX solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable(CPLEX_QP)}: Can the solver handle mixed-integer programs?

\item \code{status_map(CPLEX_QP)}: Converts status returned by the CPLEX solver to its respective CVXPY status.

\item \code{name(CPLEX_QP)}: Returns the name of the solver.

\item \code{import_solver(CPLEX_QP)}: Imports the solver.

\item \code{invert(object = CPLEX_QP, solution = list, inverse_data = InverseData)}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data(CPLEX_QP)}: Solve a problem represented by data returned from apply.

}}
