% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascvd_10y_accaha.R
\name{ascvd_10y_accaha}
\alias{ascvd_10y_accaha}
\title{ACC/AHA 2013 ASCVD risk score}
\usage{
ascvd_10y_accaha(
  race = "white",
  gender = c("male", "female"),
  age,
  totchol,
  hdl,
  sbp,
  bp_med,
  smoker,
  diabetes,
  ...
)
}
\arguments{
\item{race}{patient race (white, aa)}

\item{gender}{patient gender (male, female)}

\item{age}{patient age (years)}

\item{totchol}{Total cholesterol (mg/dL)}

\item{hdl}{HDL cholesterol (mg/dL)}

\item{sbp}{Systolic blood pressure (mm Hg)}

\item{bp_med}{Patient is on a blood pressure medication (1=Yes, 0=No)}

\item{smoker}{Current smoker (1=Yes, 0=No)}

\item{diabetes}{Diabetes (1=Yes, 0=No)}

\item{...}{Additional predictors can be passed and will be ignored}
}
\value{
Estimated 10-Y Risk for hard ASCVD (percent)
}
\description{
Computes 10-year risk for hard ASCVD event (defined as first occurrence of
non-fatal myocardial infarction (MI), congestive heart disease (CHD) death,
or fatal or nonfatal stroke).
}
\examples{
library(CVrisk)
ascvd_10y_accaha(
  race = "aa", gender = "male", age = 55,
  totchol = 213, hdl = 50, sbp = 140,
  bp_med = 0, smoker = 0, diabetes = 0
)
}
\references{
Goff, David C., et al. "2013 ACC/AHA guideline on the assessment of
cardiovascular risk: a report of the American College of
Cardiology/American Heart Association Task Force on Practice
Guidelines." Journal of the American College of Cardiology 63.25
Part B (2014): 2935-2959.
}
