% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableClass.R
\name{Table}
\alias{Table}
\title{Class initializer for NLME tables}
\usage{
Table(
  Name = "table01.csv",
  TimesList = numeric(0),
  CovrSet = "",
  WhenDose = "",
  WhenObs = "",
  VariablesList = "",
  KeepSource = FALSE,
  TimeAfterDose = FALSE,
  IRES = FALSE,
  Weight = FALSE,
  IWRES = FALSE,
  Mode = "all",
  ForSimulation = FALSE
)
}
\arguments{
\item{Name}{Character; Name of the generated table.}

\item{TimesList}{Numeric; Time values for simulation. Applicable for
time-based models only. Ignored when \code{keepSource=TRUE}.}

\item{CovrSet}{Character; Vector of covariate names. Simulation point is
added when the covariate value is set.}

\item{WhenDose}{Character or logical;
Vector of dosing compartment names. Alternatively if \code{WhenDose == TRUE},
triggers are added for all dosepoints for each PMLParametersSet separately;
that approach is useful when different models in the set have different
dosing compartments.
Simulation point is added when the dose value is set.}

\item{WhenObs}{Character; String of observed variables names. Simulation
point is added when the observation value is set.}

\item{VariablesList}{Character; List of variables from the model for
simulation.}

\item{KeepSource}{Logical; Set to \code{TRUE} to keep the number of rows
appearing in the table the same as the number of rows in the input dataset.}

\item{TimeAfterDose}{Set to \code{TRUE} to output time after dose.}

\item{IRES}{Logical; Set to \code{TRUE} to output individual residuals. Valid
only if \code{WhenObs} is specified and \code{ForSimulation==FALSE}.}

\item{Weight}{Logical; Set to \code{TRUE} to output the weight of current
observation. Valid only if \code{WhenObs} is specified and
\code{ForSimulation==FALSE}.}

\item{IWRES}{Logical; Set to \code{TRUE} to output individual weighted residuals.
Valid only if \code{WhenObs} is specified and \code{ForSimulation==FALSE}.}

\item{Mode}{Character; The mode of output. Options are \code{all} (default),
\code{unique}, \code{first}. Only applicable to non time-based models for the case
where only \code{CovrSet} is defined or the case where only \code{CovrSet} and
\code{VariablesList} are defined. Since current version supports time-based
models only, this argument is not applicable and won't change the output.}

\item{ForSimulation}{Logical; Set to \code{TRUE} if the table should be generated
during simulation, otherwise the table will be generated after fitting.}
}
\value{
A Table class used to store custom table information.
}
\description{
Creates Table class object used to specify triggers and columns for tables
output.
}
\details{
If the table has a flag \code{ForSimulation==TRUE}, it will be ignored
and won't be generated during estimation stage. Simulation stage should be
added for simulation table generation. Tables with \code{ForSimulation==FALSE}
will be ignored during simulation stage.
}
\examples{
table01 <-
  Table(Name = "table01.csv",
      TimesList = seq(1,3,1),
      CovrSet = "WT",
      WhenDose = "A1",
      WhenObs = "CObs",
      VariablesList = "C",
      KeepSource = FALSE,
      TimeAfterDose = TRUE,
      IRES = TRUE,
      Weight = TRUE,
      IWRES = TRUE,
      ForSimulation = FALSE)

}
