% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyModel.R
\name{copyModel}
\alias{copyModel}
\title{Copy model object to iterate over base model}
\usage{
copyModel(model, acceptAllEffects = FALSE, modelName = "", workingDir = "")
}
\arguments{
\item{model}{Model object to be copied}

\item{acceptAllEffects}{Set to \code{TRUE} to accept all effects, update PML statements, and test.mdl file from original model run}

\item{modelName}{New model name for subdirectory created for model output. Subdirectory is created in current working directory.}

\item{workingDir}{Working directory to run the model. Current working directory will be used if workingDir not specified.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Copies previously executed model into a new object and optionally accept all estimates returned from model execution.
A new working directory is created and all files from base model are copied into it.
}
\examples{
\donttest{
# Create initial model
model <- pkmodel(
  parameterization = "Clearance",
  absorption = "Intravenous",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  A1 = "Amount",
  CObs = "Conc",
  Time = "Act_Time",
  modelName = "pk_model"
)

# Fit Model
job <- fitmodel(model)

# Copy model and accept all effects from the original model run
vpcModel <- copyModel(model, acceptAllEffects = TRUE, modelName = "vpc_model")
}

}
