% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunCharacterization.R
\name{runCharacterizationAnalyses}
\alias{runCharacterizationAnalyses}
\title{execute a large-scale characterization study}
\usage{
runCharacterizationAnalyses(
  connectionDetails,
  targetDatabaseSchema,
  targetTable,
  outcomeDatabaseSchema,
  outcomeTable,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cdmDatabaseSchema,
  characterizationSettings,
  outputDirectory,
  executionPath = file.path(outputDirectory, "execution"),
  csvFilePrefix = "c_",
  databaseId = "1",
  showSubjectId = FALSE,
  minCellCount = 0,
  incremental = TRUE,
  threads = 1,
  minCharacterizationMean = 0.01
)
}
\arguments{
\item{connectionDetails}{The connection details to the database containing the OMOP CDM data}

\item{targetDatabaseSchema}{Schema name where your target cohort table resides. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetTable}{Name of the target cohort table.}

\item{outcomeDatabaseSchema}{Schema name where your outcome cohort table resides. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{outcomeTable}{Name of the outcome cohort table.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables.
To emulate temp tables, provide a schema with write privileges where temp tables
can be created}

\item{cdmDatabaseSchema}{The schema with the OMOP CDM data}

\item{characterizationSettings}{The study settings created using \code{createCharacterizationSettings}}

\item{outputDirectory}{The location to save the final csv files to}

\item{executionPath}{The location where intermediate results are saved to}

\item{csvFilePrefix}{A string to append the csv files in the outputDirectory}

\item{databaseId}{The unique identifier for the cdm database}

\item{showSubjectId}{Whether to include subjectId of failed rechallenge case series or hide}

\item{minCellCount}{The minimum count value that is calculated}

\item{incremental}{If TRUE then skip previously executed analyses that completed}

\item{threads}{The number of threads to use when running aggregate covariates}

\item{minCharacterizationMean}{The minimum mean threshold to extract when running aggregate covariates}
}
\value{
Multiple csv files in the outputDirectory.
}
\description{
Specify the database connection containing the CDM data, the cohort database schemas/tables,
the characterization settings and the directory to save the results to
}
\details{
The results of the characterization will be saved into an sqlite database inside the
specified saveDirectory
}
\examples{

conDet <- exampleOmopConnectionDetails()

drSet <- createDechallengeRechallengeSettings(
  targetIds = c(1,2),
  outcomeIds = 3
)

cSet <- createCharacterizationSettings(
  dechallengeRechallengeSettings = drSet
)

runCharacterizationAnalyses(
  connectionDetails = conDet,
  targetDatabaseSchema = 'main',
  targetTable = 'cohort',
  outcomeDatabaseSchema = 'main',
  outcomeTable = 'cohort',
  cdmDatabaseSchema = 'main',
  characterizationSettings = cSet,
  outputDirectory = tempdir()
)

}
\seealso{
Other LargeScale: 
\code{\link{createCharacterizationSettings}()},
\code{\link{loadCharacterizationSettings}()},
\code{\link{saveCharacterizationSettings}()}
}
\concept{LargeScale}
