% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.kspheres.R
\name{kmeans.kspheres}
\alias{kmeans.kspheres}
\title{K-Means Clustering to K-Spheres Clustering on Torus}
\usage{
kmeans.kspheres(
  data,
  centers = 10,
  type = c("homogeneous-circular", "heterogeneous-circular", "ellipsoids", "general"),
  init = c("kmeans", "hierarchical"),
  additional.condition = TRUE,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = TRUE
)
}
\arguments{
\item{data}{data n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}}

\item{centers}{either the number of clusters or a set of initial
cluster centers. If a number, a random set of row in x is
chosen as the initial centers.}

\item{type}{character which must be "homogeneous-circular",
"heterogeneous-circular", or "general".
 If "homogeneous-circular", the radii of k-spheres are identical.
 If "heterogeneous-circular", the radii of k-spheres may be different.
 If "ellipsoids", cluster with k-ellipsoids without optimized parameters.
 If, "general", clustering with k-ellipsoids. The parameters to construct
 the ellipses are optimized with elliptical k-means algorithm, which is
 modified for toroidal space. See references for the detail.
 Default is "homogeneous-circular".}

\item{init}{determine the initial parameter for option "general". Must be
"kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic kmeans
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method. Default is "hierarchical".}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scalar identity.}

\item{THRESHOLD}{number of threshold for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Default is \code{TRUE}.}
}
\value{
returns a \code{sphere.param} object,
  containing all values which determines the shape and
  location of spheres.
}
\description{
\code{kmeans.kspheres} prepares the parameters for conformity scores
  which are derived by k-means clustering on torus.
}
\examples{
data <- ILE[1:200, 1:2]

kmeans.kspheres(data, centers = 3, type = "general")
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction", and
  Jaehyeok Shin, Alessandro Rinaldo and Larry Wasserman (2019),
  "Predictive Clustering"
}
\seealso{
\code{\link[ClusTorus]{kmeans.torus}}
}
