% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_connected_comps_evolution}
\alias{plot_connected_comps_evolution}
\title{Relationship Between Number of Nearest Neighbors and Graph Connectivity}
\usage{
plot_connected_comps_evolution(nn_conn_comps_object)
}
\arguments{
\item{nn_conn_comps_object}{An object or a concatenation of objects returned by the
`get_nn_conn_comps` method.}
}
\value{
A ggplot2 object with boxplots for the connected component distributions.
}
\description{
Display the distribution of the number connected components
obtained for each number of neighbors across random seeds.
}
\note{
The number of connected components is displayed on a logarithmic scale.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(c(runif(50*10), runif(50*10, min = 1, max = 2)), nrow = 100, byrow = TRUE)
rownames(expr_matrix) = as.character(1:100)

# the graph reduction type is PCA, so we can provide the expression matrix as argument
nn_conn_comps_obj = get_nn_conn_comps(object = expr_matrix,
    n_neigh_sequence = c(2,3,5),
    config_name = "example_config",
    n_repetitions = 10,
    graph_reduction_type = "PCA",
    transpose = FALSE,
    # the following parameter is used by the irlba function and is not mandatory
    nv = 3)
plot_connected_comps_evolution(nn_conn_comps_obj)
}
